@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Database principal role.
 */
public enum class DatabasePrincipalRole(
    public val javaValue: com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole> {
    Admin(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.Admin),
    Ingestor(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.Ingestor),
    Monitor(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.Monitor),
    User(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.User),
    UnrestrictedViewer(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.UnrestrictedViewer),
    Viewer(com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole.Viewer),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.DatabasePrincipalRole):
            DatabasePrincipalRole = DatabasePrincipalRole.values().first { it.javaValue == javaType }
    }
}
