@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.AzureSkuArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.AzureSkuName
import com.pulumi.azurenative.kusto.kotlin.enums.AzureSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure SKU definition.
 * @property capacity The number of instances of the cluster.
 * @property name SKU name.
 * @property tier SKU tier.
 */
public data class AzureSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, AzureSkuName>>,
    public val tier: Output<Either<String, AzureSkuTier>>,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.AzureSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.AzureSkuArgs =
        com.pulumi.azurenative.kusto.inputs.AzureSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureSkuArgs].
 */
@PulumiTagMarker
public class AzureSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, AzureSkuName>>? = null

    private var tier: Output<Either<String, AzureSkuTier>>? = null

    /**
     * @param value The number of instances of the cluster.
     */
    @JvmName("grdyeuxfboxsplyd")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value SKU name.
     */
    @JvmName("paefbtqadlwqegse")
    public suspend fun name(`value`: Output<Either<String, AzureSkuName>>) {
        this.name = value
    }

    /**
     * @param value SKU tier.
     */
    @JvmName("befhsvieycpianou")
    public suspend fun tier(`value`: Output<Either<String, AzureSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The number of instances of the cluster.
     */
    @JvmName("etfqjeprafxjmvfx")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("mvbbsenwcgxkmlnl")
    public suspend fun name(`value`: Either<String, AzureSkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("ehgjjmdmohobbppk")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("rkjhlwqeuyulwhkv")
    public fun name(`value`: AzureSkuName) {
        val toBeMapped = Either.ofRight<String, AzureSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU tier.
     */
    @JvmName("vehdtgfjvfdmbwke")
    public suspend fun tier(`value`: Either<String, AzureSkuTier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value SKU tier.
     */
    @JvmName("guxhphtgsclklixr")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value SKU tier.
     */
    @JvmName("ebjimtwpsngbknlr")
    public fun tier(`value`: AzureSkuTier) {
        val toBeMapped = Either.ofRight<String, AzureSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): AzureSkuArgs = AzureSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier ?: throw PulumiNullFieldException("tier"),
    )
}
