@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetReadWriteDatabasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetReadWriteDatabasePlainArgs(
    public val clusterName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetReadWriteDatabasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetReadWriteDatabasePlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetReadWriteDatabasePlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReadWriteDatabasePlainArgs].
 */
@PulumiTagMarker
public class GetReadWriteDatabasePlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("jxubdomyglmvgmku")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("bauuahjfsaisaaee")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("xmpvqclejutmqtns")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetReadWriteDatabasePlainArgs = GetReadWriteDatabasePlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
