@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetSandboxCustomImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sandboxCustomImageName The name of the sandbox custom image.
 */
public data class GetSandboxCustomImagePlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
    public val sandboxCustomImageName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetSandboxCustomImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetSandboxCustomImagePlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetSandboxCustomImagePlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sandboxCustomImageName(sandboxCustomImageName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSandboxCustomImagePlainArgs].
 */
@PulumiTagMarker
public class GetSandboxCustomImagePlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var sandboxCustomImageName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("vtnjtgdgaivkbauw")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vekoceasjqeksgmh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the sandbox custom image.
     */
    @JvmName("ldemtfomqnajactg")
    public suspend fun sandboxCustomImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sandboxCustomImageName = mapped
    }

    internal fun build(): GetSandboxCustomImagePlainArgs = GetSandboxCustomImagePlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sandboxCustomImageName = sandboxCustomImageName ?: throw
            PulumiNullFieldException("sandboxCustomImageName"),
    )
}
