@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Tables that will be included and excluded in the follower database
 * @property externalTablesToExclude List of external tables to exclude from the follower database
 * @property externalTablesToInclude List of external tables to include in the follower database
 * @property functionsToExclude List of functions to exclude from the follower database
 * @property functionsToInclude List of functions to include in the follower database
 * @property materializedViewsToExclude List of materialized views to exclude from the follower database
 * @property materializedViewsToInclude List of materialized views to include in the follower database
 * @property tablesToExclude List of tables to exclude from the follower database
 * @property tablesToInclude List of tables to include in the follower database
 */
public data class TableLevelSharingPropertiesArgs(
    public val externalTablesToExclude: Output<List<String>>? = null,
    public val externalTablesToInclude: Output<List<String>>? = null,
    public val functionsToExclude: Output<List<String>>? = null,
    public val functionsToInclude: Output<List<String>>? = null,
    public val materializedViewsToExclude: Output<List<String>>? = null,
    public val materializedViewsToInclude: Output<List<String>>? = null,
    public val tablesToExclude: Output<List<String>>? = null,
    public val tablesToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs =
        com.pulumi.azurenative.kusto.inputs.TableLevelSharingPropertiesArgs.builder()
            .externalTablesToExclude(
                externalTablesToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .externalTablesToInclude(
                externalTablesToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .functionsToExclude(functionsToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .functionsToInclude(functionsToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .materializedViewsToExclude(
                materializedViewsToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToInclude(
                materializedViewsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tablesToExclude(tablesToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tablesToInclude(tablesToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TableLevelSharingPropertiesArgs].
 */
@PulumiTagMarker
public class TableLevelSharingPropertiesArgsBuilder internal constructor() {
    private var externalTablesToExclude: Output<List<String>>? = null

    private var externalTablesToInclude: Output<List<String>>? = null

    private var functionsToExclude: Output<List<String>>? = null

    private var functionsToInclude: Output<List<String>>? = null

    private var materializedViewsToExclude: Output<List<String>>? = null

    private var materializedViewsToInclude: Output<List<String>>? = null

    private var tablesToExclude: Output<List<String>>? = null

    private var tablesToInclude: Output<List<String>>? = null

    /**
     * @param value List of external tables to exclude from the follower database
     */
    @JvmName("yapmbokcmpxukpij")
    public suspend fun externalTablesToExclude(`value`: Output<List<String>>) {
        this.externalTablesToExclude = value
    }

    @JvmName("atbfnjvtdgslpcio")
    public suspend fun externalTablesToExclude(vararg values: Output<String>) {
        this.externalTablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables to exclude from the follower database
     */
    @JvmName("uxmpdgrchtiohstf")
    public suspend fun externalTablesToExclude(values: List<Output<String>>) {
        this.externalTablesToExclude = Output.all(values)
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("tonaupfslrmelkmm")
    public suspend fun externalTablesToInclude(`value`: Output<List<String>>) {
        this.externalTablesToInclude = value
    }

    @JvmName("wmuyflcxxqwaplxp")
    public suspend fun externalTablesToInclude(vararg values: Output<String>) {
        this.externalTablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("ndvbjmuakgnmwtcy")
    public suspend fun externalTablesToInclude(values: List<Output<String>>) {
        this.externalTablesToInclude = Output.all(values)
    }

    /**
     * @param value List of functions to exclude from the follower database
     */
    @JvmName("ovsrihtdaqxqjklc")
    public suspend fun functionsToExclude(`value`: Output<List<String>>) {
        this.functionsToExclude = value
    }

    @JvmName("uhlvvtfqidbavmmr")
    public suspend fun functionsToExclude(vararg values: Output<String>) {
        this.functionsToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of functions to exclude from the follower database
     */
    @JvmName("binrpogvgmjpxxbw")
    public suspend fun functionsToExclude(values: List<Output<String>>) {
        this.functionsToExclude = Output.all(values)
    }

    /**
     * @param value List of functions to include in the follower database
     */
    @JvmName("njtdplhsburaukao")
    public suspend fun functionsToInclude(`value`: Output<List<String>>) {
        this.functionsToInclude = value
    }

    @JvmName("leyrjmufymfjhacp")
    public suspend fun functionsToInclude(vararg values: Output<String>) {
        this.functionsToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of functions to include in the follower database
     */
    @JvmName("ykrmenwhojaxtclk")
    public suspend fun functionsToInclude(values: List<Output<String>>) {
        this.functionsToInclude = Output.all(values)
    }

    /**
     * @param value List of materialized views to exclude from the follower database
     */
    @JvmName("pphtxtbyufhwdkim")
    public suspend fun materializedViewsToExclude(`value`: Output<List<String>>) {
        this.materializedViewsToExclude = value
    }

    @JvmName("iboyxmfqnhjhvhjb")
    public suspend fun materializedViewsToExclude(vararg values: Output<String>) {
        this.materializedViewsToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views to exclude from the follower database
     */
    @JvmName("llimgntjjuahfsam")
    public suspend fun materializedViewsToExclude(values: List<Output<String>>) {
        this.materializedViewsToExclude = Output.all(values)
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("oxxeylvhavwupsmo")
    public suspend fun materializedViewsToInclude(`value`: Output<List<String>>) {
        this.materializedViewsToInclude = value
    }

    @JvmName("vlegkosihrdfycaw")
    public suspend fun materializedViewsToInclude(vararg values: Output<String>) {
        this.materializedViewsToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("oujkympdknnuadyp")
    public suspend fun materializedViewsToInclude(values: List<Output<String>>) {
        this.materializedViewsToInclude = Output.all(values)
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("uudkxiotlumoptsr")
    public suspend fun tablesToExclude(`value`: Output<List<String>>) {
        this.tablesToExclude = value
    }

    @JvmName("csfdvigahtkexetf")
    public suspend fun tablesToExclude(vararg values: Output<String>) {
        this.tablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("mnhneecedahwdrgn")
    public suspend fun tablesToExclude(values: List<Output<String>>) {
        this.tablesToExclude = Output.all(values)
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("ulldnccupmcmnqrs")
    public suspend fun tablesToInclude(`value`: Output<List<String>>) {
        this.tablesToInclude = value
    }

    @JvmName("skkqmtvmxdjnmvly")
    public suspend fun tablesToInclude(vararg values: Output<String>) {
        this.tablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("umqhfltegkvqnafm")
    public suspend fun tablesToInclude(values: List<Output<String>>) {
        this.tablesToInclude = Output.all(values)
    }

    /**
     * @param value List of external tables to exclude from the follower database
     */
    @JvmName("slvotqovbqvlgbpb")
    public suspend fun externalTablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param values List of external tables to exclude from the follower database
     */
    @JvmName("wyhniabfmfgrlvqq")
    public suspend fun externalTablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("gkkilhvgrwgxdyyi")
    public suspend fun externalTablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("hsdvtkxlrvrkmuug")
    public suspend fun externalTablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param value List of functions to exclude from the follower database
     */
    @JvmName("smtioykxbtutosvs")
    public suspend fun functionsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsToExclude = mapped
    }

    /**
     * @param values List of functions to exclude from the follower database
     */
    @JvmName("cbuxmbbvqximtikl")
    public suspend fun functionsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionsToExclude = mapped
    }

    /**
     * @param value List of functions to include in the follower database
     */
    @JvmName("cmodfabxlewluhfo")
    public suspend fun functionsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsToInclude = mapped
    }

    /**
     * @param values List of functions to include in the follower database
     */
    @JvmName("ttrinvqcdlrkkeme")
    public suspend fun functionsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionsToInclude = mapped
    }

    /**
     * @param value List of materialized views to exclude from the follower database
     */
    @JvmName("edxovraadqbegqck")
    public suspend fun materializedViewsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param values List of materialized views to exclude from the follower database
     */
    @JvmName("vycaryuiawfjnvug")
    public suspend fun materializedViewsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("afifkdxxywjbbcij")
    public suspend fun materializedViewsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("mbvijvmykchmgjov")
    public suspend fun materializedViewsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("wqsuphcfchotoira")
    public suspend fun tablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("rxqroxygfcaqeasr")
    public suspend fun tablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("hbwqbqnkhndrjdkr")
    public suspend fun tablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("wchrftfuclfisgak")
    public suspend fun tablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    internal fun build(): TableLevelSharingPropertiesArgs = TableLevelSharingPropertiesArgs(
        externalTablesToExclude = externalTablesToExclude,
        externalTablesToInclude = externalTablesToInclude,
        functionsToExclude = functionsToExclude,
        functionsToInclude = functionsToInclude,
        materializedViewsToExclude = materializedViewsToExclude,
        materializedViewsToInclude = materializedViewsToInclude,
        tablesToExclude = tablesToExclude,
        tablesToInclude = tablesToInclude,
    )
}
