@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin as latestOperationResultResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ResourceSetResponse.Companion.toKotlin as resourceSetResponseToKotlin

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.azurenative.labservices.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Represents an environment instance
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Environment myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/labs/{labName}/environmentsettings/{environmentSettingName}/environments/{environmentName}
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * The name or email address of the user who has claimed the environment
     */
    public val claimedByUserName: Output<String>
        get() = javaResource.claimedByUserName().applyValue({ args0 -> args0 })

    /**
     * The AAD object Id of the user who has claimed the environment
     */
    public val claimedByUserObjectId: Output<String>
        get() = javaResource.claimedByUserObjectId().applyValue({ args0 -> args0 })

    /**
     * The user principal Id of the user who has claimed the environment
     */
    public val claimedByUserPrincipalId: Output<String>
        get() = javaResource.claimedByUserPrincipalId().applyValue({ args0 -> args0 })

    /**
     * Is the environment claimed or not
     */
    public val isClaimed: Output<Boolean>
        get() = javaResource.isClaimed().applyValue({ args0 -> args0 })

    /**
     * Last known power state of the environment
     */
    public val lastKnownPowerState: Output<String>
        get() = javaResource.lastKnownPowerState().applyValue({ args0 -> args0 })

    /**
     * The details of the latest operation. ex: status, error
     */
    public val latestOperationResult: Output<LatestOperationResultResponse>
        get() = javaResource.latestOperationResult().applyValue({ args0 ->
            args0.let({ args0 ->
                latestOperationResultResponseToKotlin(args0)
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network details of the environment
     */
    public val networkInterface: Output<NetworkInterfaceResponse>
        get() = javaResource.networkInterface().applyValue({ args0 ->
            args0.let({ args0 ->
                networkInterfaceResponseToKotlin(args0)
            })
        })

    /**
     * When the password was last reset on the environment.
     */
    public val passwordLastReset: Output<String>
        get() = javaResource.passwordLastReset().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The set of a VM and the setting id it was created for
     */
    public val resourceSets: Output<ResourceSetResponse>?
        get() = javaResource.resourceSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * How long the environment has been used by a lab user
     */
    public val totalUsage: Output<String>
        get() = javaResource.totalUsage().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>?
        get() = javaResource.uniqueIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.azurenative.labservices.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit):
    Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
