@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.EnvironmentArgs.builder
import com.pulumi.azurenative.labservices.kotlin.inputs.ResourceSetArgs
import com.pulumi.azurenative.labservices.kotlin.inputs.ResourceSetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an environment instance
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:Environment myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}/labs/{labName}/environmentsettings/{environmentSettingName}/environments/{environmentName}
 * ```
 * @property environmentName The name of the environment.
 * @property environmentSettingName The name of the environment Setting.
 * @property labAccountName The name of the lab Account.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property provisioningState The provisioning status of the resource.
 * @property resourceGroupName The name of the resource group.
 * @property resourceSets The set of a VM and the setting id it was created for
 * @property tags The tags of the resource.
 * @property uniqueIdentifier The unique immutable identifier of a resource (Guid).
 */
public data class EnvironmentArgs(
    public val environmentName: Output<String>? = null,
    public val environmentSettingName: Output<String>? = null,
    public val labAccountName: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceSets: Output<ResourceSetArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uniqueIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.EnvironmentArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.EnvironmentArgs =
        com.pulumi.azurenative.labservices.EnvironmentArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .environmentSettingName(environmentSettingName?.applyValue({ args0 -> args0 }))
            .labAccountName(labAccountName?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceSets(resourceSets?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uniqueIdentifier(uniqueIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentArgs].
 */
@PulumiTagMarker
public class EnvironmentArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var environmentSettingName: Output<String>? = null

    private var labAccountName: Output<String>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceSets: Output<ResourceSetArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uniqueIdentifier: Output<String>? = null

    /**
     * @param value The name of the environment.
     */
    @JvmName("uwslgffiblngytyg")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The name of the environment Setting.
     */
    @JvmName("kesujnffddlevpyo")
    public suspend fun environmentSettingName(`value`: Output<String>) {
        this.environmentSettingName = value
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("lcnlxfpswbybdufa")
    public suspend fun labAccountName(`value`: Output<String>) {
        this.labAccountName = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("sejkfyqycoravobt")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("jwsptwrndnakmdqa")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("bsvwpxjerqhoowyl")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ywlglraaxbfkgtaa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The set of a VM and the setting id it was created for
     */
    @JvmName("qghawtekkxfaenbl")
    public suspend fun resourceSets(`value`: Output<ResourceSetArgs>) {
        this.resourceSets = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("tcajxfnljcxwyojv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("rqpckhghyfvdogbs")
    public suspend fun uniqueIdentifier(`value`: Output<String>) {
        this.uniqueIdentifier = value
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("qhoonuhhhbplvmpe")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the environment Setting.
     */
    @JvmName("lxeglhygwhnhpwhu")
    public suspend fun environmentSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentSettingName = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("bmvavvwejokcsqpl")
    public suspend fun labAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("yvuoumbpmernblij")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("elfckustlfcrtvyu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning status of the resource.
     */
    @JvmName("sfbjvpldhngchmei")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("umvqmhdgpsirsaon")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The set of a VM and the setting id it was created for
     */
    @JvmName("tyapwxlsqfegrjnw")
    public suspend fun resourceSets(`value`: ResourceSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSets = mapped
    }

    /**
     * @param argument The set of a VM and the setting id it was created for
     */
    @JvmName("jikfjhllbecmiwap")
    public suspend fun resourceSets(argument: suspend ResourceSetArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceSets = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ggbqougtjnmvogdx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("yneibjufhttqfcko")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique immutable identifier of a resource (Guid).
     */
    @JvmName("achevudunhmlpnyr")
    public suspend fun uniqueIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIdentifier = mapped
    }

    internal fun build(): EnvironmentArgs = EnvironmentArgs(
        environmentName = environmentName,
        environmentSettingName = environmentSettingName,
        labAccountName = labAccountName,
        labName = labName,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        resourceSets = resourceSets,
        tags = tags,
        uniqueIdentifier = uniqueIdentifier,
    )
}
