@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SizeConfigurationPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.LatestOperationResultResponse.Companion.toKotlin as latestOperationResultResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SizeConfigurationPropertiesResponse.Companion.toKotlin as sizeConfigurationPropertiesResponseToKotlin

/**
 * Builder for [LabAccount].
 */
@PulumiTagMarker
public class LabAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabAccountArgs = LabAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabAccountArgsBuilder.() -> Unit) {
        val builder = LabAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LabAccount {
        val builtJavaResource = com.pulumi.azurenative.labservices.LabAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LabAccount(builtJavaResource)
    }
}

/**
 * Represents a lab account.
 * Azure REST API version: 2018-10-15. Prior API version in Azure Native 1.x: 2018-10-15.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:LabAccount myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labaccounts/{labAccountName}
 * ```
 */
public class LabAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.LabAccount,
) : KotlinCustomResource(javaResource, LabAccountMapper) {
    /**
     * Represents if region selection is enabled
     */
    public val enabledRegionSelection: Output<Boolean>?
        get() = javaResource.enabledRegionSelection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The details of the latest operation. ex: status, error
     */
    public val latestOperationResult: Output<LatestOperationResultResponse>
        get() = javaResource.latestOperationResult().applyValue({ args0 ->
            args0.let({ args0 ->
                latestOperationResultResponseToKotlin(args0)
            })
        })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Represents the size configuration under the lab account
     */
    public val sizeConfiguration: Output<SizeConfigurationPropertiesResponse>
        get() = javaResource.sizeConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                sizeConfigurationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>?
        get() = javaResource.uniqueIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LabAccountMapper : ResourceMapper<LabAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.LabAccount::class == javaResource::class

    override fun map(javaResource: Resource): LabAccount = LabAccount(
        javaResource as
            com.pulumi.azurenative.labservices.LabAccount,
    )
}

/**
 * @see [LabAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LabAccount].
 */
public suspend fun labAccount(name: String, block: suspend LabAccountResourceBuilder.() -> Unit):
    LabAccount {
    val builder = LabAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LabAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun labAccount(name: String): LabAccount {
    val builder = LabAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
