@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum indicating if user is adding or removing a favorite lab
 */
public enum class AddRemove(
    public val javaValue: com.pulumi.azurenative.labservices.enums.AddRemove,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.AddRemove> {
    /**
     * Indicates that a user is adding a favorite lab
     */
    Add(com.pulumi.azurenative.labservices.enums.AddRemove.Add),

    /**
     * Indicates that a user is removing a favorite lab
     */
    Remove(com.pulumi.azurenative.labservices.enums.AddRemove.Remove),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.AddRemove = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.AddRemove): AddRemove =
            AddRemove.values().first { it.javaValue == javaType }
    }
}
