@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether a VM will get shutdown when it hasn't been connected to after a period of time.
 */
public enum class EnableState(
    public val javaValue: com.pulumi.azurenative.labservices.enums.EnableState,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.EnableState> {
    Enabled(com.pulumi.azurenative.labservices.enums.EnableState.Enabled),
    Disabled(com.pulumi.azurenative.labservices.enums.EnableState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.EnableState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.EnableState): EnableState =
            EnableState.values().first { it.javaValue == javaType }
    }
}
