@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetEnvironmentSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentSettingName The name of the environment Setting.
 * @property expand Specify the $expand query. Example: 'properties($select=publishingState)'
 * @property labAccountName The name of the lab Account.
 * @property labName The name of the lab.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetEnvironmentSettingPlainArgs(
    public val environmentSettingName: String,
    public val expand: String? = null,
    public val labAccountName: String,
    public val labName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetEnvironmentSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetEnvironmentSettingPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetEnvironmentSettingPlainArgs.builder()
            .environmentSettingName(environmentSettingName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .labAccountName(labAccountName.let({ args0 -> args0 }))
            .labName(labName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentSettingPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentSettingPlainArgsBuilder internal constructor() {
    private var environmentSettingName: String? = null

    private var expand: String? = null

    private var labAccountName: String? = null

    private var labName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the environment Setting.
     */
    @JvmName("klgrfeteurlmvnnl")
    public suspend fun environmentSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentSettingName = mapped
    }

    /**
     * @param value Specify the $expand query. Example: 'properties($select=publishingState)'
     */
    @JvmName("wowwcvcgngrkukto")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("ueurjhwfcfvtresg")
    public suspend fun labAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("lindybmtfdvlmqaq")
    public suspend fun labName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dyywihygibfcweqw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEnvironmentSettingPlainArgs = GetEnvironmentSettingPlainArgs(
        environmentSettingName = environmentSettingName ?: throw
            PulumiNullFieldException("environmentSettingName"),
        expand = expand,
        labAccountName = labAccountName ?: throw PulumiNullFieldException("labAccountName"),
        labName = labName ?: throw PulumiNullFieldException("labName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
