@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetGalleryImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Specify the $expand query. Example: 'properties($select=author)'
 * @property galleryImageName The name of the gallery Image.
 * @property labAccountName The name of the lab Account.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetGalleryImagePlainArgs(
    public val expand: String? = null,
    public val galleryImageName: String,
    public val labAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetGalleryImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetGalleryImagePlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetGalleryImagePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .galleryImageName(galleryImageName.let({ args0 -> args0 }))
            .labAccountName(labAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryImagePlainArgs].
 */
@PulumiTagMarker
public class GetGalleryImagePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var galleryImageName: String? = null

    private var labAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Specify the $expand query. Example: 'properties($select=author)'
     */
    @JvmName("obcmwpkjrdqkggxu")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the gallery Image.
     */
    @JvmName("sxfffqxpueiugmkn")
    public suspend fun galleryImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the lab Account.
     */
    @JvmName("oaohuhbjxbxncpik")
    public suspend fun labAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labAccountName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dlpegfjwyyqqgygi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryImagePlainArgs = GetGalleryImagePlainArgs(
        expand = expand,
        galleryImageName = galleryImageName ?: throw PulumiNullFieldException("galleryImageName"),
        labAccountName = labAccountName ?: throw PulumiNullFieldException("labAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
