@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.GetLabPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labPlanName The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetLabPlanPlainArgs(
    public val labPlanName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.GetLabPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.GetLabPlanPlainArgs =
        com.pulumi.azurenative.labservices.inputs.GetLabPlanPlainArgs.builder()
            .labPlanName(labPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabPlanPlainArgs].
 */
@PulumiTagMarker
public class GetLabPlanPlainArgsBuilder internal constructor() {
    private var labPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI.
     */
    @JvmName("jkicnptbtqhhasaw")
    public suspend fun labPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labPlanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rlvpcrmyttacqarq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLabPlanPlainArgs = GetLabPlanPlainArgs(
        labPlanName = labPlanName ?: throw PulumiNullFieldException("labPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
