@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.inputs

import com.pulumi.azurenative.labservices.inputs.ResourceSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a VM and the setting Id it was created for.
 * @property resourceSettingId resourceSettingId for the environment
 * @property vmResourceId VM resource Id for the environment
 */
public data class ResourceSetArgs(
    public val resourceSettingId: Output<String>? = null,
    public val vmResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.inputs.ResourceSetArgs> {
    override fun toJava(): com.pulumi.azurenative.labservices.inputs.ResourceSetArgs =
        com.pulumi.azurenative.labservices.inputs.ResourceSetArgs.builder()
            .resourceSettingId(resourceSettingId?.applyValue({ args0 -> args0 }))
            .vmResourceId(vmResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetArgs].
 */
@PulumiTagMarker
public class ResourceSetArgsBuilder internal constructor() {
    private var resourceSettingId: Output<String>? = null

    private var vmResourceId: Output<String>? = null

    /**
     * @param value resourceSettingId for the environment
     */
    @JvmName("onyxxxxbwocjecnh")
    public suspend fun resourceSettingId(`value`: Output<String>) {
        this.resourceSettingId = value
    }

    /**
     * @param value VM resource Id for the environment
     */
    @JvmName("ffpyrplsjygcjhdm")
    public suspend fun vmResourceId(`value`: Output<String>) {
        this.vmResourceId = value
    }

    /**
     * @param value resourceSettingId for the environment
     */
    @JvmName("hejqtjjujrhlxbas")
    public suspend fun resourceSettingId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSettingId = mapped
    }

    /**
     * @param value VM resource Id for the environment
     */
    @JvmName("iikqqgayqrwwrbxe")
    public suspend fun vmResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmResourceId = mapped
    }

    internal fun build(): ResourceSetArgs = ResourceSetArgs(
        resourceSettingId = resourceSettingId,
        vmResourceId = vmResourceId,
    )
}
