@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The lab user list management profile.
 * @property activeDirectoryGroupId The AAD group ID which this lab roster is populated from. Having this set enables AAD sync mode.
 * @property lmsInstance The base URI identifying the lms instance.
 * @property ltiClientId The unique id of the azure lab services tool in the lms.
 * @property ltiContextId The unique context identifier for the lab in the lms.
 * @property ltiRosterEndpoint The uri of the names and roles service endpoint on the lms for the class attached to this lab.
 */
public data class RosterProfileResponse(
    public val activeDirectoryGroupId: String? = null,
    public val lmsInstance: String? = null,
    public val ltiClientId: String? = null,
    public val ltiContextId: String? = null,
    public val ltiRosterEndpoint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.RosterProfileResponse):
            RosterProfileResponse = RosterProfileResponse(
            activeDirectoryGroupId = javaType.activeDirectoryGroupId().map({ args0 -> args0 }).orElse(null),
            lmsInstance = javaType.lmsInstance().map({ args0 -> args0 }).orElse(null),
            ltiClientId = javaType.ltiClientId().map({ args0 -> args0 }).orElse(null),
            ltiContextId = javaType.ltiContextId().map({ args0 -> args0 }).orElse(null),
            ltiRosterEndpoint = javaType.ltiRosterEndpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
