@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details about the state of the reference virtual machine.
 * @property lastKnownPowerState Last known compute power state captured in DTL
 * @property powerState The power state of the reference virtual machine.
 * @property rdpAuthority The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
 * @property sshAuthority The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
 */
public data class VmStateDetailsResponse(
    public val lastKnownPowerState: String,
    public val powerState: String,
    public val rdpAuthority: String,
    public val sshAuthority: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.VmStateDetailsResponse):
            VmStateDetailsResponse = VmStateDetailsResponse(
            lastKnownPowerState = javaType.lastKnownPowerState(),
            powerState = javaType.powerState(),
            rdpAuthority = javaType.rdpAuthority(),
            sshAuthority = javaType.sshAuthority(),
        )
    }
}
