@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin.inputs

import com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Key and identity details for Customer Managed Key encryption of load test resource.
 * @property identity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyUrl key encryption key Url, versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
 */
public data class EncryptionPropertiesArgs(
    public val identity: Output<EncryptionPropertiesIdentityArgs>? = null,
    public val keyUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.loadtestservice.inputs.EncryptionPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyUrl(keyUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var identity: Output<EncryptionPropertiesIdentityArgs>? = null

    private var keyUrl: Output<String>? = null

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("dpnmbdnnqianliac")
    public suspend fun identity(`value`: Output<EncryptionPropertiesIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value key encryption key Url, versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
     */
    @JvmName("rqujqctmbtqfhxld")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("kiobtmtkgckovhau")
    public suspend fun identity(`value`: EncryptionPropertiesIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("qeghormsohlxjpub")
    public suspend
    fun identity(argument: suspend EncryptionPropertiesIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value key encryption key Url, versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
     */
    @JvmName("hhspjfpgtpnoiqse")
    public suspend fun keyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        identity = identity,
        keyUrl = keyUrl,
    )
}
