@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Key and identity details for Customer Managed Key encryption of load test resource.
 * @property identity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyUrl key encryption key Url, versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek.
 */
public data class EncryptionPropertiesResponse(
    public val identity: EncryptionPropertiesIdentityResponse? = null,
    public val keyUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.loadtestservice.outputs.EncryptionPropertiesResponse):
            EncryptionPropertiesResponse = EncryptionPropertiesResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.loadtestservice.kotlin.outputs.EncryptionPropertiesIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyUrl = javaType.keyUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
