@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.AgreementType
import com.pulumi.azurenative.logic.kotlin.inputs.AgreementContentArgs
import com.pulumi.azurenative.logic.kotlin.inputs.AgreementContentArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.BusinessIdentityArgs
import com.pulumi.azurenative.logic.kotlin.inputs.BusinessIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account agreement.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update an agreement
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountAgreement = new AzureNative.Logic.IntegrationAccountAgreement("integrationAccountAgreement", new()
 *     {
 *         AgreementName = "testAgreement",
 *         AgreementType = AzureNative.Logic.AgreementType.AS2,
 *         Content = new AzureNative.Logic.Inputs.AgreementContentArgs
 *         {
 *             AS2 = new AzureNative.Logic.Inputs.AS2AgreementContentArgs
 *             {
 *                 ReceiveAgreement = new AzureNative.Logic.Inputs.AS2OneWayAgreementArgs
 *                 {
 *                     ProtocolSettings = new AzureNative.Logic.Inputs.AS2ProtocolSettingsArgs
 *                     {
 *                         AcknowledgementConnectionSettings = new AzureNative.Logic.Inputs.AS2AcknowledgementConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         EnvelopeSettings = new AzureNative.Logic.Inputs.AS2EnvelopeSettingsArgs
 *                         {
 *                             AutogenerateFileName = true,
 *                             FileNameTemplate = "Test",
 *                             MessageContentType = "text/plain",
 *                             SuspendMessageOnFileNameGenerationError = true,
 *                             TransmitFileNameInMimeHeader = true,
 *                         },
 *                         ErrorSettings = new AzureNative.Logic.Inputs.AS2ErrorSettingsArgs
 *                         {
 *                             ResendIfMDNNotReceived = true,
 *                             SuspendDuplicateMessage = true,
 *                         },
 *                         MdnSettings = new AzureNative.Logic.Inputs.AS2MdnSettingsArgs
 *                         {
 *                             DispositionNotificationTo = "http://tempuri.org",
 *                             MdnText = "Sample",
 *                             MicHashingAlgorithm = AzureNative.Logic.HashingAlgorithm.SHA1,
 *                             NeedMDN = true,
 *                             ReceiptDeliveryUrl = "http://tempuri.org",
 *                             SendInboundMDNToMessageBox = true,
 *                             SendMDNAsynchronously = true,
 *                             SignMDN = true,
 *                             SignOutboundMDNIfOptional = true,
 *                         },
 *                         MessageConnectionSettings = new AzureNative.Logic.Inputs.AS2MessageConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         SecuritySettings = new AzureNative.Logic.Inputs.AS2SecuritySettingsArgs
 *                         {
 *                             EnableNRRForInboundDecodedMessages = true,
 *                             EnableNRRForInboundEncodedMessages = true,
 *                             EnableNRRForInboundMDN = true,
 *                             EnableNRRForOutboundDecodedMessages = true,
 *                             EnableNRRForOutboundEncodedMessages = true,
 *                             EnableNRRForOutboundMDN = true,
 *                             OverrideGroupSigningCertificate = false,
 *                         },
 *                         ValidationSettings = new AzureNative.Logic.Inputs.AS2ValidationSettingsArgs
 *                         {
 *                             CheckCertificateRevocationListOnReceive = true,
 *                             CheckCertificateRevocationListOnSend = true,
 *                             CheckDuplicateMessage = true,
 *                             CompressMessage = true,
 *                             EncryptMessage = false,
 *                             EncryptionAlgorithm = AzureNative.Logic.EncryptionAlgorithm.AES128,
 *                             InterchangeDuplicatesValidityDays = 100,
 *                             OverrideMessageProperties = true,
 *                             SignMessage = false,
 *                         },
 *                     },
 *                     ReceiverBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "ZZ",
 *                         Value = "ZZ",
 *                     },
 *                     SenderBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "AA",
 *                     },
 *                 },
 *                 SendAgreement = new AzureNative.Logic.Inputs.AS2OneWayAgreementArgs
 *                 {
 *                     ProtocolSettings = new AzureNative.Logic.Inputs.AS2ProtocolSettingsArgs
 *                     {
 *                         AcknowledgementConnectionSettings = new AzureNative.Logic.Inputs.AS2AcknowledgementConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         EnvelopeSettings = new AzureNative.Logic.Inputs.AS2EnvelopeSettingsArgs
 *                         {
 *                             AutogenerateFileName = true,
 *                             FileNameTemplate = "Test",
 *                             MessageContentType = "text/plain",
 *                             SuspendMessageOnFileNameGenerationError = true,
 *                             TransmitFileNameInMimeHeader = true,
 *                         },
 *                         ErrorSettings = new AzureNative.Logic.Inputs.AS2ErrorSettingsArgs
 *                         {
 *                             ResendIfMDNNotReceived = true,
 *                             SuspendDuplicateMessage = true,
 *                         },
 *                         MdnSettings = new AzureNative.Logic.Inputs.AS2MdnSettingsArgs
 *                         {
 *                             DispositionNotificationTo = "http://tempuri.org",
 *                             MdnText = "Sample",
 *                             MicHashingAlgorithm = AzureNative.Logic.HashingAlgorithm.SHA1,
 *                             NeedMDN = true,
 *                             ReceiptDeliveryUrl = "http://tempuri.org",
 *                             SendInboundMDNToMessageBox = true,
 *                             SendMDNAsynchronously = true,
 *                             SignMDN = true,
 *                             SignOutboundMDNIfOptional = true,
 *                         },
 *                         MessageConnectionSettings = new AzureNative.Logic.Inputs.AS2MessageConnectionSettingsArgs
 *                         {
 *                             IgnoreCertificateNameMismatch = true,
 *                             KeepHttpConnectionAlive = true,
 *                             SupportHttpStatusCodeContinue = true,
 *                             UnfoldHttpHeaders = true,
 *                         },
 *                         SecuritySettings = new AzureNative.Logic.Inputs.AS2SecuritySettingsArgs
 *                         {
 *                             EnableNRRForInboundDecodedMessages = true,
 *                             EnableNRRForInboundEncodedMessages = true,
 *                             EnableNRRForInboundMDN = true,
 *                             EnableNRRForOutboundDecodedMessages = true,
 *                             EnableNRRForOutboundEncodedMessages = true,
 *                             EnableNRRForOutboundMDN = true,
 *                             OverrideGroupSigningCertificate = false,
 *                         },
 *                         ValidationSettings = new AzureNative.Logic.Inputs.AS2ValidationSettingsArgs
 *                         {
 *                             CheckCertificateRevocationListOnReceive = true,
 *                             CheckCertificateRevocationListOnSend = true,
 *                             CheckDuplicateMessage = true,
 *                             CompressMessage = true,
 *                             EncryptMessage = false,
 *                             EncryptionAlgorithm = AzureNative.Logic.EncryptionAlgorithm.AES128,
 *                             InterchangeDuplicatesValidityDays = 100,
 *                             OverrideMessageProperties = true,
 *                             SignMessage = false,
 *                         },
 *                     },
 *                     ReceiverBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "AA",
 *                     },
 *                     SenderBusinessIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "ZZ",
 *                         Value = "ZZ",
 *                     },
 *                 },
 *             },
 *         },
 *         GuestIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *         {
 *             Qualifier = "AA",
 *             Value = "AA",
 *         },
 *         GuestPartner = "GuestPartner",
 *         HostIdentity = new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *         {
 *             Qualifier = "ZZ",
 *             Value = "ZZ",
 *         },
 *         HostPartner = "HostPartner",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *         Tags =
 *         {
 *             { "IntegrationAccountAgreement", "<IntegrationAccountAgreementName>" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountAgreement(ctx, "integrationAccountAgreement", &logic.IntegrationAccountAgreementArgs{
 * 			AgreementName: pulumi.String("testAgreement"),
 * 			AgreementType: logic.AgreementTypeAS2,
 * 			Content: &logic.AgreementContentArgs{
 * 				AS2: &logic.AS2AgreementContentArgs{
 * 					ReceiveAgreement: &logic.AS2OneWayAgreementArgs{
 * 						ProtocolSettings: &logic.AS2ProtocolSettingsArgs{
 * 							AcknowledgementConnectionSettings: &logic.AS2AcknowledgementConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							EnvelopeSettings: &logic.AS2EnvelopeSettingsArgs{
 * 								AutogenerateFileName:                    pulumi.Bool(true),
 * 								FileNameTemplate:                        pulumi.String("Test"),
 * 								MessageContentType:                      pulumi.String("text/plain"),
 * 								SuspendMessageOnFileNameGenerationError: pulumi.Bool(true),
 * 								TransmitFileNameInMimeHeader:            pulumi.Bool(true),
 * 							},
 * 							ErrorSettings: &logic.AS2ErrorSettingsArgs{
 * 								ResendIfMDNNotReceived:  pulumi.Bool(true),
 * 								SuspendDuplicateMessage: pulumi.Bool(true),
 * 							},
 * 							MdnSettings: &logic.AS2MdnSettingsArgs{
 * 								DispositionNotificationTo:  pulumi.String("http://tempuri.org"),
 * 								MdnText:                    pulumi.String("Sample"),
 * 								MicHashingAlgorithm:        pulumi.String(logic.HashingAlgorithmSHA1),
 * 								NeedMDN:                    pulumi.Bool(true),
 * 								ReceiptDeliveryUrl:         pulumi.String("http://tempuri.org"),
 * 								SendInboundMDNToMessageBox: pulumi.Bool(true),
 * 								SendMDNAsynchronously:      pulumi.Bool(true),
 * 								SignMDN:                    pulumi.Bool(true),
 * 								SignOutboundMDNIfOptional:  pulumi.Bool(true),
 * 							},
 * 							MessageConnectionSettings: &logic.AS2MessageConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							SecuritySettings: &logic.AS2SecuritySettingsArgs{
 * 								EnableNRRForInboundDecodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundEncodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundMDN:              pulumi.Bool(true),
 * 								EnableNRRForOutboundDecodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundEncodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundMDN:             pulumi.Bool(true),
 * 								OverrideGroupSigningCertificate:     pulumi.Bool(false),
 * 							},
 * 							ValidationSettings: &logic.AS2ValidationSettingsArgs{
 * 								CheckCertificateRevocationListOnReceive: pulumi.Bool(true),
 * 								CheckCertificateRevocationListOnSend:    pulumi.Bool(true),
 * 								CheckDuplicateMessage:                   pulumi.Bool(true),
 * 								CompressMessage:                         pulumi.Bool(true),
 * 								EncryptMessage:                          pulumi.Bool(false),
 * 								EncryptionAlgorithm:                     pulumi.String(logic.EncryptionAlgorithmAES128),
 * 								InterchangeDuplicatesValidityDays:       pulumi.Int(100),
 * 								OverrideMessageProperties:               pulumi.Bool(true),
 * 								SignMessage:                             pulumi.Bool(false),
 * 							},
 * 						},
 * 						ReceiverBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("ZZ"),
 * 							Value:     pulumi.String("ZZ"),
 * 						},
 * 						SenderBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("AA"),
 * 							Value:     pulumi.String("AA"),
 * 						},
 * 					},
 * 					SendAgreement: &logic.AS2OneWayAgreementArgs{
 * 						ProtocolSettings: &logic.AS2ProtocolSettingsArgs{
 * 							AcknowledgementConnectionSettings: &logic.AS2AcknowledgementConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							EnvelopeSettings: &logic.AS2EnvelopeSettingsArgs{
 * 								AutogenerateFileName:                    pulumi.Bool(true),
 * 								FileNameTemplate:                        pulumi.String("Test"),
 * 								MessageContentType:                      pulumi.String("text/plain"),
 * 								SuspendMessageOnFileNameGenerationError: pulumi.Bool(true),
 * 								TransmitFileNameInMimeHeader:            pulumi.Bool(true),
 * 							},
 * 							ErrorSettings: &logic.AS2ErrorSettingsArgs{
 * 								ResendIfMDNNotReceived:  pulumi.Bool(true),
 * 								SuspendDuplicateMessage: pulumi.Bool(true),
 * 							},
 * 							MdnSettings: &logic.AS2MdnSettingsArgs{
 * 								DispositionNotificationTo:  pulumi.String("http://tempuri.org"),
 * 								MdnText:                    pulumi.String("Sample"),
 * 								MicHashingAlgorithm:        pulumi.String(logic.HashingAlgorithmSHA1),
 * 								NeedMDN:                    pulumi.Bool(true),
 * 								ReceiptDeliveryUrl:         pulumi.String("http://tempuri.org"),
 * 								SendInboundMDNToMessageBox: pulumi.Bool(true),
 * 								SendMDNAsynchronously:      pulumi.Bool(true),
 * 								SignMDN:                    pulumi.Bool(true),
 * 								SignOutboundMDNIfOptional:  pulumi.Bool(true),
 * 							},
 * 							MessageConnectionSettings: &logic.AS2MessageConnectionSettingsArgs{
 * 								IgnoreCertificateNameMismatch: pulumi.Bool(true),
 * 								KeepHttpConnectionAlive:       pulumi.Bool(true),
 * 								SupportHttpStatusCodeContinue: pulumi.Bool(true),
 * 								UnfoldHttpHeaders:             pulumi.Bool(true),
 * 							},
 * 							SecuritySettings: &logic.AS2SecuritySettingsArgs{
 * 								EnableNRRForInboundDecodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundEncodedMessages:  pulumi.Bool(true),
 * 								EnableNRRForInboundMDN:              pulumi.Bool(true),
 * 								EnableNRRForOutboundDecodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundEncodedMessages: pulumi.Bool(true),
 * 								EnableNRRForOutboundMDN:             pulumi.Bool(true),
 * 								OverrideGroupSigningCertificate:     pulumi.Bool(false),
 * 							},
 * 							ValidationSettings: &logic.AS2ValidationSettingsArgs{
 * 								CheckCertificateRevocationListOnReceive: pulumi.Bool(true),
 * 								CheckCertificateRevocationListOnSend:    pulumi.Bool(true),
 * 								CheckDuplicateMessage:                   pulumi.Bool(true),
 * 								CompressMessage:                         pulumi.Bool(true),
 * 								EncryptMessage:                          pulumi.Bool(false),
 * 								EncryptionAlgorithm:                     pulumi.String(logic.EncryptionAlgorithmAES128),
 * 								InterchangeDuplicatesValidityDays:       pulumi.Int(100),
 * 								OverrideMessageProperties:               pulumi.Bool(true),
 * 								SignMessage:                             pulumi.Bool(false),
 * 							},
 * 						},
 * 						ReceiverBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("AA"),
 * 							Value:     pulumi.String("AA"),
 * 						},
 * 						SenderBusinessIdentity: &logic.BusinessIdentityArgs{
 * 							Qualifier: pulumi.String("ZZ"),
 * 							Value:     pulumi.String("ZZ"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			GuestIdentity: &logic.BusinessIdentityArgs{
 * 				Qualifier: pulumi.String("AA"),
 * 				Value:     pulumi.String("AA"),
 * 			},
 * 			GuestPartner: pulumi.String("GuestPartner"),
 * 			HostIdentity: &logic.BusinessIdentityArgs{
 * 				Qualifier: pulumi.String("ZZ"),
 * 				Value:     pulumi.String("ZZ"),
 * 			},
 * 			HostPartner:            pulumi.String("HostPartner"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"IntegrationAccountAgreement": pulumi.String("<IntegrationAccountAgreementName>"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountAgreement;
 * import com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs;
 * import com.pulumi.azurenative.logic.inputs.AgreementContentArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2AgreementContentArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2OneWayAgreementArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ProtocolSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2AcknowledgementConnectionSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2MessageConnectionSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2SecuritySettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.AS2ValidationSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountAgreement = new IntegrationAccountAgreement("integrationAccountAgreement", IntegrationAccountAgreementArgs.builder()
 *             .agreementName("testAgreement")
 *             .agreementType("AS2")
 *             .content(AgreementContentArgs.builder()
 *                 .aS2(AS2AgreementContentArgs.builder()
 *                     .receiveAgreement(AS2OneWayAgreementArgs.builder()
 *                         .protocolSettings(AS2ProtocolSettingsArgs.builder()
 *                             .acknowledgementConnectionSettings(AS2AcknowledgementConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .envelopeSettings(AS2EnvelopeSettingsArgs.builder()
 *                                 .autogenerateFileName(true)
 *                                 .fileNameTemplate("Test")
 *                                 .messageContentType("text/plain")
 *                                 .suspendMessageOnFileNameGenerationError(true)
 *                                 .transmitFileNameInMimeHeader(true)
 *                                 .build())
 *                             .errorSettings(AS2ErrorSettingsArgs.builder()
 *                                 .resendIfMDNNotReceived(true)
 *                                 .suspendDuplicateMessage(true)
 *                                 .build())
 *                             .mdnSettings(AS2MdnSettingsArgs.builder()
 *                                 .dispositionNotificationTo("http://tempuri.org")
 *                                 .mdnText("Sample")
 *                                 .micHashingAlgorithm("SHA1")
 *                                 .needMDN(true)
 *                                 .receiptDeliveryUrl("http://tempuri.org")
 *                                 .sendInboundMDNToMessageBox(true)
 *                                 .sendMDNAsynchronously(true)
 *                                 .signMDN(true)
 *                                 .signOutboundMDNIfOptional(true)
 *                                 .build())
 *                             .messageConnectionSettings(AS2MessageConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .securitySettings(AS2SecuritySettingsArgs.builder()
 *                                 .enableNRRForInboundDecodedMessages(true)
 *                                 .enableNRRForInboundEncodedMessages(true)
 *                                 .enableNRRForInboundMDN(true)
 *                                 .enableNRRForOutboundDecodedMessages(true)
 *                                 .enableNRRForOutboundEncodedMessages(true)
 *                                 .enableNRRForOutboundMDN(true)
 *                                 .overrideGroupSigningCertificate(false)
 *                                 .build())
 *                             .validationSettings(AS2ValidationSettingsArgs.builder()
 *                                 .checkCertificateRevocationListOnReceive(true)
 *                                 .checkCertificateRevocationListOnSend(true)
 *                                 .checkDuplicateMessage(true)
 *                                 .compressMessage(true)
 *                                 .encryptMessage(false)
 *                                 .encryptionAlgorithm("AES128")
 *                                 .interchangeDuplicatesValidityDays(100)
 *                                 .overrideMessageProperties(true)
 *                                 .signMessage(false)
 *                                 .build())
 *                             .build())
 *                         .receiverBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("ZZ")
 *                             .value("ZZ")
 *                             .build())
 *                         .senderBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("AA")
 *                             .value("AA")
 *                             .build())
 *                         .build())
 *                     .sendAgreement(AS2OneWayAgreementArgs.builder()
 *                         .protocolSettings(AS2ProtocolSettingsArgs.builder()
 *                             .acknowledgementConnectionSettings(AS2AcknowledgementConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .envelopeSettings(AS2EnvelopeSettingsArgs.builder()
 *                                 .autogenerateFileName(true)
 *                                 .fileNameTemplate("Test")
 *                                 .messageContentType("text/plain")
 *                                 .suspendMessageOnFileNameGenerationError(true)
 *                                 .transmitFileNameInMimeHeader(true)
 *                                 .build())
 *                             .errorSettings(AS2ErrorSettingsArgs.builder()
 *                                 .resendIfMDNNotReceived(true)
 *                                 .suspendDuplicateMessage(true)
 *                                 .build())
 *                             .mdnSettings(AS2MdnSettingsArgs.builder()
 *                                 .dispositionNotificationTo("http://tempuri.org")
 *                                 .mdnText("Sample")
 *                                 .micHashingAlgorithm("SHA1")
 *                                 .needMDN(true)
 *                                 .receiptDeliveryUrl("http://tempuri.org")
 *                                 .sendInboundMDNToMessageBox(true)
 *                                 .sendMDNAsynchronously(true)
 *                                 .signMDN(true)
 *                                 .signOutboundMDNIfOptional(true)
 *                                 .build())
 *                             .messageConnectionSettings(AS2MessageConnectionSettingsArgs.builder()
 *                                 .ignoreCertificateNameMismatch(true)
 *                                 .keepHttpConnectionAlive(true)
 *                                 .supportHttpStatusCodeContinue(true)
 *                                 .unfoldHttpHeaders(true)
 *                                 .build())
 *                             .securitySettings(AS2SecuritySettingsArgs.builder()
 *                                 .enableNRRForInboundDecodedMessages(true)
 *                                 .enableNRRForInboundEncodedMessages(true)
 *                                 .enableNRRForInboundMDN(true)
 *                                 .enableNRRForOutboundDecodedMessages(true)
 *                                 .enableNRRForOutboundEncodedMessages(true)
 *                                 .enableNRRForOutboundMDN(true)
 *                                 .overrideGroupSigningCertificate(false)
 *                                 .build())
 *                             .validationSettings(AS2ValidationSettingsArgs.builder()
 *                                 .checkCertificateRevocationListOnReceive(true)
 *                                 .checkCertificateRevocationListOnSend(true)
 *                                 .checkDuplicateMessage(true)
 *                                 .compressMessage(true)
 *                                 .encryptMessage(false)
 *                                 .encryptionAlgorithm("AES128")
 *                                 .interchangeDuplicatesValidityDays(100)
 *                                 .overrideMessageProperties(true)
 *                                 .signMessage(false)
 *                                 .build())
 *                             .build())
 *                         .receiverBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("AA")
 *                             .value("AA")
 *                             .build())
 *                         .senderBusinessIdentity(BusinessIdentityArgs.builder()
 *                             .qualifier("ZZ")
 *                             .value("ZZ")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .guestIdentity(BusinessIdentityArgs.builder()
 *                 .qualifier("AA")
 *                 .value("AA")
 *                 .build())
 *             .guestPartner("GuestPartner")
 *             .hostIdentity(BusinessIdentityArgs.builder()
 *                 .qualifier("ZZ")
 *                 .value("ZZ")
 *                 .build())
 *             .hostPartner("HostPartner")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .tags(Map.of("IntegrationAccountAgreement", "<IntegrationAccountAgreementName>"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountAgreement <IntegrationAccountAgreementName> /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}
 * ```
 * @property agreementName The integration account agreement name.
 * @property agreementType The agreement type.
 * @property content The agreement content.
 * @property guestIdentity The business identity of the guest partner.
 * @property guestPartner The integration account partner that is set as guest partner for this agreement.
 * @property hostIdentity The business identity of the host partner.
 * @property hostPartner The integration account partner that is set as host partner for this agreement.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountAgreementArgs(
    public val agreementName: Output<String>? = null,
    public val agreementType: Output<AgreementType>? = null,
    public val content: Output<AgreementContentArgs>? = null,
    public val guestIdentity: Output<BusinessIdentityArgs>? = null,
    public val guestPartner: Output<String>? = null,
    public val hostIdentity: Output<BusinessIdentityArgs>? = null,
    public val hostPartner: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs =
        com.pulumi.azurenative.logic.IntegrationAccountAgreementArgs.builder()
            .agreementName(agreementName?.applyValue({ args0 -> args0 }))
            .agreementType(agreementType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .content(content?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .guestIdentity(guestIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .guestPartner(guestPartner?.applyValue({ args0 -> args0 }))
            .hostIdentity(hostIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostPartner(hostPartner?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountAgreementArgs].
 */
@PulumiTagMarker
public class IntegrationAccountAgreementArgsBuilder internal constructor() {
    private var agreementName: Output<String>? = null

    private var agreementType: Output<AgreementType>? = null

    private var content: Output<AgreementContentArgs>? = null

    private var guestIdentity: Output<BusinessIdentityArgs>? = null

    private var guestPartner: Output<String>? = null

    private var hostIdentity: Output<BusinessIdentityArgs>? = null

    private var hostPartner: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The integration account agreement name.
     */
    @JvmName("frucikpyrqlxvexy")
    public suspend fun agreementName(`value`: Output<String>) {
        this.agreementName = value
    }

    /**
     * @param value The agreement type.
     */
    @JvmName("vwlpmwojxdfnqrii")
    public suspend fun agreementType(`value`: Output<AgreementType>) {
        this.agreementType = value
    }

    /**
     * @param value The agreement content.
     */
    @JvmName("yhdcccxwpbgsqnpk")
    public suspend fun content(`value`: Output<AgreementContentArgs>) {
        this.content = value
    }

    /**
     * @param value The business identity of the guest partner.
     */
    @JvmName("qecsfswbcydxfubd")
    public suspend fun guestIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.guestIdentity = value
    }

    /**
     * @param value The integration account partner that is set as guest partner for this agreement.
     */
    @JvmName("eqtxtrmnlukexcej")
    public suspend fun guestPartner(`value`: Output<String>) {
        this.guestPartner = value
    }

    /**
     * @param value The business identity of the host partner.
     */
    @JvmName("svioewhhhitncoxr")
    public suspend fun hostIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.hostIdentity = value
    }

    /**
     * @param value The integration account partner that is set as host partner for this agreement.
     */
    @JvmName("vjkqvwjqotpncugq")
    public suspend fun hostPartner(`value`: Output<String>) {
        this.hostPartner = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("gfigwleoxsoorlih")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("eyclqmwpaljisise")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("tkramtmoyisqomtd")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("pqcjdaenklafbmsy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("nfmyiouphkmlpyyh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The integration account agreement name.
     */
    @JvmName("ohrhibwutqhkxfxb")
    public suspend fun agreementName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreementName = mapped
    }

    /**
     * @param value The agreement type.
     */
    @JvmName("recipbmndwfkfole")
    public suspend fun agreementType(`value`: AgreementType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreementType = mapped
    }

    /**
     * @param value The agreement content.
     */
    @JvmName("vjuinwejuflldrsd")
    public suspend fun content(`value`: AgreementContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param argument The agreement content.
     */
    @JvmName("pftxyxwqxlxyecuh")
    public suspend fun content(argument: suspend AgreementContentArgsBuilder.() -> Unit) {
        val toBeMapped = AgreementContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.content = mapped
    }

    /**
     * @param value The business identity of the guest partner.
     */
    @JvmName("ogxsjckrnnahkbkr")
    public suspend fun guestIdentity(`value`: BusinessIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestIdentity = mapped
    }

    /**
     * @param argument The business identity of the guest partner.
     */
    @JvmName("jormvakyrfedvars")
    public suspend fun guestIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guestIdentity = mapped
    }

    /**
     * @param value The integration account partner that is set as guest partner for this agreement.
     */
    @JvmName("gvjifrkdcvmspqvw")
    public suspend fun guestPartner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestPartner = mapped
    }

    /**
     * @param value The business identity of the host partner.
     */
    @JvmName("iatnihwbgpbntvoi")
    public suspend fun hostIdentity(`value`: BusinessIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostIdentity = mapped
    }

    /**
     * @param argument The business identity of the host partner.
     */
    @JvmName("ljaexabucmhkhpge")
    public suspend fun hostIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostIdentity = mapped
    }

    /**
     * @param value The integration account partner that is set as host partner for this agreement.
     */
    @JvmName("lvgimgsncyubjjdd")
    public suspend fun hostPartner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPartner = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("uwsrwllmtakulutm")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("firkmqgkhberknng")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("rtnkdqhpsjsjsalk")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("uiabgcnscsxiyugh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("xalpwgqvefjyrobm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("ixesukxjpvmruwbh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountAgreementArgs = IntegrationAccountAgreementArgs(
        agreementName = agreementName,
        agreementType = agreementType,
        content = content,
        guestIdentity = guestIdentity,
        guestPartner = guestPartner,
        hostIdentity = hostIdentity,
        hostPartner = hostPartner,
        integrationAccountName = integrationAccountName,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
