@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountAssemblyArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.AssemblyPropertiesArgs
import com.pulumi.azurenative.logic.kotlin.inputs.AssemblyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The assembly definition.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update an account assembly
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountAssembly = new AzureNative.Logic.IntegrationAccountAssembly("integrationAccountAssembly", new()
 *     {
 *         AssemblyArtifactName = "testAssembly",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Properties = new AzureNative.Logic.Inputs.AssemblyPropertiesArgs
 *         {
 *             AssemblyName = "System.IdentityModel.Tokens.Jwt",
 *             Content = "Base64 encoded Assembly Content",
 *             Metadata = null,
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountAssembly(ctx, "integrationAccountAssembly", &logic.IntegrationAccountAssemblyArgs{
 * 			AssemblyArtifactName:   pulumi.String("testAssembly"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Properties: &logic.AssemblyPropertiesArgs{
 * 				AssemblyName: pulumi.String("System.IdentityModel.Tokens.Jwt"),
 * 				Content:      pulumi.Any("Base64 encoded Assembly Content"),
 * 				Metadata:     pulumi.Any(nil),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountAssembly;
 * import com.pulumi.azurenative.logic.IntegrationAccountAssemblyArgs;
 * import com.pulumi.azurenative.logic.inputs.AssemblyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountAssembly = new IntegrationAccountAssembly("integrationAccountAssembly", IntegrationAccountAssemblyArgs.builder()
 *             .assemblyArtifactName("testAssembly")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .properties(AssemblyPropertiesArgs.builder()
 *                 .assemblyName("System.IdentityModel.Tokens.Jwt")
 *                 .content("Base64 encoded Assembly Content")
 *                 .metadata()
 *                 .build())
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountAssembly testAssembly /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}
 * ```
 * @property assemblyArtifactName The assembly artifact name.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property properties The assembly properties.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountAssemblyArgs(
    public val assemblyArtifactName: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AssemblyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountAssemblyArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountAssemblyArgs =
        com.pulumi.azurenative.logic.IntegrationAccountAssemblyArgs.builder()
            .assemblyArtifactName(assemblyArtifactName?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountAssemblyArgs].
 */
@PulumiTagMarker
public class IntegrationAccountAssemblyArgsBuilder internal constructor() {
    private var assemblyArtifactName: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<AssemblyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The assembly artifact name.
     */
    @JvmName("orrqpqgasjxdcjhc")
    public suspend fun assemblyArtifactName(`value`: Output<String>) {
        this.assemblyArtifactName = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("tscrodlgjnhhsvoh")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("hykhrkhfrqxtsavn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The assembly properties.
     */
    @JvmName("mrbtmyorwftyxstp")
    public suspend fun properties(`value`: Output<AssemblyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("heisfadbhpdygpgm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("jlyctbrceuunsmev")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The assembly artifact name.
     */
    @JvmName("usjyjijjkvdbpsqf")
    public suspend fun assemblyArtifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assemblyArtifactName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("kfcjuqxvlconucda")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("qahlbfpejxvqvieq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The assembly properties.
     */
    @JvmName("iulnncilselwwarv")
    public suspend fun properties(`value`: AssemblyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The assembly properties.
     */
    @JvmName("clucruxadwhtcxii")
    public suspend fun properties(argument: suspend AssemblyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AssemblyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xglngqbcxugdjeeq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("bqmfxadjehgfruml")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("anwjocrfhrrafgrv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountAssemblyArgs = IntegrationAccountAssemblyArgs(
        assemblyArtifactName = assemblyArtifactName,
        integrationAccountName = integrationAccountName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
