@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.BatchConfigurationPropertiesResponse
import com.pulumi.azurenative.logic.kotlin.outputs.BatchConfigurationPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationAccountBatchConfiguration].
 */
@PulumiTagMarker
public class IntegrationAccountBatchConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountBatchConfigurationArgs =
        IntegrationAccountBatchConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend IntegrationAccountBatchConfigurationArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountBatchConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationAccountBatchConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountBatchConfiguration(builtJavaResource)
    }
}

/**
 * The batch configuration resource definition.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update a batch configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountBatchConfiguration = new AzureNative.Logic.IntegrationAccountBatchConfiguration("integrationAccountBatchConfiguration", new()
 *     {
 *         BatchConfigurationName = "testBatchConfiguration",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Properties = new AzureNative.Logic.Inputs.BatchConfigurationPropertiesArgs
 *         {
 *             BatchGroupName = "DEFAULT",
 *             ReleaseCriteria = new AzureNative.Logic.Inputs.BatchReleaseCriteriaArgs
 *             {
 *                 BatchSize = 234567,
 *                 MessageCount = 10,
 *                 Recurrence = new AzureNative.Logic.Inputs.WorkflowTriggerRecurrenceArgs
 *                 {
 *                     Frequency = AzureNative.Logic.RecurrenceFrequency.Minute,
 *                     Interval = 1,
 *                     StartTime = "2017-03-24T11:43:00",
 *                     TimeZone = "India Standard Time",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountBatchConfiguration(ctx, "integrationAccountBatchConfiguration", &logic.IntegrationAccountBatchConfigurationArgs{
 * 			BatchConfigurationName: pulumi.String("testBatchConfiguration"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			Properties: &logic.BatchConfigurationPropertiesArgs{
 * 				BatchGroupName: pulumi.String("DEFAULT"),
 * 				ReleaseCriteria: &logic.BatchReleaseCriteriaArgs{
 * 					BatchSize:    pulumi.Int(234567),
 * 					MessageCount: pulumi.Int(10),
 * 					Recurrence: &logic.WorkflowTriggerRecurrenceArgs{
 * 						Frequency: pulumi.String(logic.RecurrenceFrequencyMinute),
 * 						Interval:  pulumi.Int(1),
 * 						StartTime: pulumi.String("2017-03-24T11:43:00"),
 * 						TimeZone:  pulumi.String("India Standard Time"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration;
 * import com.pulumi.azurenative.logic.IntegrationAccountBatchConfigurationArgs;
 * import com.pulumi.azurenative.logic.inputs.BatchConfigurationPropertiesArgs;
 * import com.pulumi.azurenative.logic.inputs.BatchReleaseCriteriaArgs;
 * import com.pulumi.azurenative.logic.inputs.WorkflowTriggerRecurrenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountBatchConfiguration = new IntegrationAccountBatchConfiguration("integrationAccountBatchConfiguration", IntegrationAccountBatchConfigurationArgs.builder()
 *             .batchConfigurationName("testBatchConfiguration")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .properties(BatchConfigurationPropertiesArgs.builder()
 *                 .batchGroupName("DEFAULT")
 *                 .releaseCriteria(BatchReleaseCriteriaArgs.builder()
 *                     .batchSize(234567)
 *                     .messageCount(10)
 *                     .recurrence(WorkflowTriggerRecurrenceArgs.builder()
 *                         .frequency("Minute")
 *                         .interval(1)
 *                         .startTime("2017-03-24T11:43:00")
 *                         .timeZone("India Standard Time")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountBatchConfiguration testBatchConfiguration /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/batchConfigurations/{batchConfigurationName}
 * ```
 */
public class IntegrationAccountBatchConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration,
) : KotlinCustomResource(javaResource, IntegrationAccountBatchConfigurationMapper) {
    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The batch configuration properties.
     */
    public val properties: Output<BatchConfigurationPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountBatchConfigurationMapper :
    ResourceMapper<IntegrationAccountBatchConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountBatchConfiguration =
        IntegrationAccountBatchConfiguration(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountBatchConfiguration,
        )
}

/**
 * @see [IntegrationAccountBatchConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountBatchConfiguration].
 */
public suspend fun integrationAccountBatchConfiguration(
    name: String,
    block: suspend IntegrationAccountBatchConfigurationResourceBuilder.() -> Unit,
):
    IntegrationAccountBatchConfiguration {
    val builder = IntegrationAccountBatchConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountBatchConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountBatchConfiguration(name: String):
    IntegrationAccountBatchConfiguration {
    val builder = IntegrationAccountBatchConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
