@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountMapPropertiesResponseParametersSchema
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse.Companion.toKotlin as contentLinkResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountMapPropertiesResponseParametersSchema.Companion.toKotlin as integrationAccountMapPropertiesResponseParametersSchemaToKotlin

/**
 * Builder for [IntegrationAccountMap].
 */
@PulumiTagMarker
public class IntegrationAccountMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountMapArgs = IntegrationAccountMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountMapArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IntegrationAccountMap {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountMap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountMap(builtJavaResource)
    }
}

/**
 * The integration account map.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a map
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountMap = new AzureNative.Logic.IntegrationAccountMap("integrationAccountMap", new()
 *     {
 *         Content = @"<?xml version=""1.0"" encoding=""UTF-16""?>
 * <xsl:stylesheet xmlns:xsl=""http://www.w3.org/1999/XSL/Transform"" xmlns:msxsl=""urn:schemas-microsoft-com:xslt"" xmlns:var=""http://schemas.microsoft.com/BizTalk/2003/var"" exclude-result-prefixes=""msxsl var s0 userCSharp"" version=""1.0"" xmlns:ns0=""http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema"" xmlns:s0=""http://BizTalk_Server_Project4.StringFunctoidsSourceSchema"" xmlns:userCSharp=""http://schemas.microsoft.com/BizTalk/2003/userCSharp"">
 *   <xsl:import href=""http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt"" />
 *   <xsl:output omit-xml-declaration=""yes"" method=""xml"" version=""1.0"" />
 *   <xsl:template match=""/"">
 *     <xsl:apply-templates select=""/s0:Root"" />
 *   </xsl:template>
 *   <xsl:template match=""/s0:Root"">
 *     <xsl:variable name=""var:v1"" select=""userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)"" />
 *     <xsl:variable name=""var:v2"" select=""userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v3"" select=""userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v4"" select=""userCSharp:StringUpperCase(string(UppercaseSource/text()))"" />
 *     <xsl:variable name=""var:v5"" select=""userCSharp:StringLowerCase(string(LowercaseSource/text()))"" />
 *     <xsl:variable name=""var:v6"" select=""userCSharp:StringSize(string(SizeSource/text()))"" />
 *     <xsl:variable name=""var:v7"" select=""userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)"" />
 *     <xsl:variable name=""var:v8"" select=""userCSharp:StringConcat(string(StringConcatSource/text()))"" />
 *     <xsl:variable name=""var:v9"" select=""userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))"" />
 *     <xsl:variable name=""var:v10"" select=""userCSharp:StringTrimRight(string(StringRightTrimSource/text()))"" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select=""$var:v1"" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select=""$var:v2"" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select=""$var:v3"" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select=""$var:v4"" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select=""$var:v5"" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select=""$var:v6"" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select=""$var:v7"" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select=""$var:v8"" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select=""$var:v9"" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select=""$var:v10"" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>",
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         MapName = "testMap",
 *         MapType = AzureNative.Logic.MapType.Xslt,
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountMap(ctx, "integrationAccountMap", &logic.IntegrationAccountMapArgs{
 * 			Content: pulumi.String(`<?xml version="1.0" encoding="UTF-16"?>
 * <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="http://schemas.microsoft.com/BizTalk/2003/var" exclude-result-prefixes="msxsl var s0 userCSharp" version="1.0" xmlns:ns0="http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema" xmlns:s0="http://BizTalk_Server_Project4.StringFunctoidsSourceSchema" xmlns:userCSharp="http://schemas.microsoft.com/BizTalk/2003/userCSharp">
 *   <xsl:import href="http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt" />
 *   <xsl:output omit-xml-declaration="yes" method="xml" version="1.0" />
 *   <xsl:template match="/">
 *     <xsl:apply-templates select="/s0:Root" />
 *   </xsl:template>
 *   <xsl:template match="/s0:Root">
 *     <xsl:variable name="var:v1" select="userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)" />
 *     <xsl:variable name="var:v2" select="userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v3" select="userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v4" select="userCSharp:StringUpperCase(string(UppercaseSource/text()))" />
 *     <xsl:variable name="var:v5" select="userCSharp:StringLowerCase(string(LowercaseSource/text()))" />
 *     <xsl:variable name="var:v6" select="userCSharp:StringSize(string(SizeSource/text()))" />
 *     <xsl:variable name="var:v7" select="userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)" />
 *     <xsl:variable name="var:v8" select="userCSharp:StringConcat(string(StringConcatSource/text()))" />
 *     <xsl:variable name="var:v9" select="userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))" />
 *     <xsl:variable name="var:v10" select="userCSharp:StringTrimRight(string(StringRightTrimSource/text()))" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select="$var:v1" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select="$var:v2" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select="$var:v3" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select="$var:v4" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select="$var:v5" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select="$var:v6" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select="$var:v7" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select="$var:v8" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select="$var:v9" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select="$var:v10" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>`),
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			MapName:                pulumi.String("testMap"),
 * 			MapType:                pulumi.String(logic.MapTypeXslt),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountMap;
 * import com.pulumi.azurenative.logic.IntegrationAccountMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountMap = new IntegrationAccountMap("integrationAccountMap", IntegrationAccountMapArgs.builder()
 *             .content("""
 * <?xml version="1.0" encoding="UTF-16"?>
 * <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:var="http://schemas.microsoft.com/BizTalk/2003/var" exclude-result-prefixes="msxsl var s0 userCSharp" version="1.0" xmlns:ns0="http://BizTalk_Server_Project4.StringFunctoidsDestinationSchema" xmlns:s0="http://BizTalk_Server_Project4.StringFunctoidsSourceSchema" xmlns:userCSharp="http://schemas.microsoft.com/BizTalk/2003/userCSharp">
 *   <xsl:import href="http://btsfunctoids.blob.core.windows.net/functoids/functoids.xslt" />
 *   <xsl:output omit-xml-declaration="yes" method="xml" version="1.0" />
 *   <xsl:template match="/">
 *     <xsl:apply-templates select="/s0:Root" />
 *   </xsl:template>
 *   <xsl:template match="/s0:Root">
 *     <xsl:variable name="var:v1" select="userCSharp:StringFind(string(StringFindSource/text()) , &quot;SearchString&quot;)" />
 *     <xsl:variable name="var:v2" select="userCSharp:StringLeft(string(StringLeftSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v3" select="userCSharp:StringRight(string(StringRightSource/text()) , &quot;2&quot;)" />
 *     <xsl:variable name="var:v4" select="userCSharp:StringUpperCase(string(UppercaseSource/text()))" />
 *     <xsl:variable name="var:v5" select="userCSharp:StringLowerCase(string(LowercaseSource/text()))" />
 *     <xsl:variable name="var:v6" select="userCSharp:StringSize(string(SizeSource/text()))" />
 *     <xsl:variable name="var:v7" select="userCSharp:StringSubstring(string(StringExtractSource/text()) , &quot;0&quot; , &quot;2&quot;)" />
 *     <xsl:variable name="var:v8" select="userCSharp:StringConcat(string(StringConcatSource/text()))" />
 *     <xsl:variable name="var:v9" select="userCSharp:StringTrimLeft(string(StringLeftTrimSource/text()))" />
 *     <xsl:variable name="var:v10" select="userCSharp:StringTrimRight(string(StringRightTrimSource/text()))" />
 *     <ns0:Root>
 *       <StringFindDestination>
 *         <xsl:value-of select="$var:v1" />
 *       </StringFindDestination>
 *       <StringLeftDestination>
 *         <xsl:value-of select="$var:v2" />
 *       </StringLeftDestination>
 *       <StringRightDestination>
 *         <xsl:value-of select="$var:v3" />
 *       </StringRightDestination>
 *       <UppercaseDestination>
 *         <xsl:value-of select="$var:v4" />
 *       </UppercaseDestination>
 *       <LowercaseDestination>
 *         <xsl:value-of select="$var:v5" />
 *       </LowercaseDestination>
 *       <SizeDestination>
 *         <xsl:value-of select="$var:v6" />
 *       </SizeDestination>
 *       <StringExtractDestination>
 *         <xsl:value-of select="$var:v7" />
 *       </StringExtractDestination>
 *       <StringConcatDestination>
 *         <xsl:value-of select="$var:v8" />
 *       </StringConcatDestination>
 *       <StringLeftTrimDestination>
 *         <xsl:value-of select="$var:v9" />
 *       </StringLeftTrimDestination>
 *       <StringRightTrimDestination>
 *         <xsl:value-of select="$var:v10" />
 *       </StringRightTrimDestination>
 *     </ns0:Root>
 *   </xsl:template>
 * </xsl:stylesheet>            """)
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .mapName("testMap")
 *             .mapType("Xslt")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a map larger than 4 MB
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountMap = new AzureNative.Logic.IntegrationAccountMap("integrationAccountMap", new()
 *     {
 *         ContentType = "application/xml",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         MapName = "testMap",
 *         MapType = AzureNative.Logic.MapType.Xslt,
 *         Metadata = null,
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountMap(ctx, "integrationAccountMap", &logic.IntegrationAccountMapArgs{
 * 			ContentType:            pulumi.String("application/xml"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Location:               pulumi.String("westus"),
 * 			MapName:                pulumi.String("testMap"),
 * 			MapType:                pulumi.String(logic.MapTypeXslt),
 * 			Metadata:               pulumi.Any(nil),
 * 			ResourceGroupName:      pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountMap;
 * import com.pulumi.azurenative.logic.IntegrationAccountMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountMap = new IntegrationAccountMap("integrationAccountMap", IntegrationAccountMapArgs.builder()
 *             .contentType("application/xml")
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .mapName("testMap")
 *             .mapType("Xslt")
 *             .metadata()
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountMap testMap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/maps/{mapName}
 * ```
 */
public class IntegrationAccountMap internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountMap,
) : KotlinCustomResource(javaResource, IntegrationAccountMapMapper) {
    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The content.
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The content link.
     */
    public val contentLink: Output<ContentLinkResponse>
        get() = javaResource.contentLink().applyValue({ args0 ->
            args0.let({ args0 ->
                contentLinkResponseToKotlin(args0)
            })
        })

    /**
     * The content type.
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The map type.
     */
    public val mapType: Output<String>
        get() = javaResource.mapType().applyValue({ args0 -> args0 })

    /**
     * The metadata.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters schema of integration account map.
     */
    public val parametersSchema: Output<IntegrationAccountMapPropertiesResponseParametersSchema>?
        get() = javaResource.parametersSchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    integrationAccountMapPropertiesResponseParametersSchemaToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountMapMapper : ResourceMapper<IntegrationAccountMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountMap::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountMap =
        IntegrationAccountMap(javaResource as com.pulumi.azurenative.logic.IntegrationAccountMap)
}

/**
 * @see [IntegrationAccountMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountMap].
 */
public suspend fun integrationAccountMap(
    name: String,
    block: suspend IntegrationAccountMapResourceBuilder.() -> Unit,
): IntegrationAccountMap {
    val builder = IntegrationAccountMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountMap(name: String): IntegrationAccountMap {
    val builder = IntegrationAccountMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
