@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.RosettaNetPipActivitySettingsArgs
import com.pulumi.azurenative.logic.kotlin.inputs.RosettaNetPipActivitySettingsArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.RosettaNetPipRoleSettingsArgs
import com.pulumi.azurenative.logic.kotlin.inputs.RosettaNetPipRoleSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account RosettaNet process configuration.
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Create or update an RosettaNetProcessConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rosettaNetProcessConfiguration = new AzureNative.Logic.RosettaNetProcessConfiguration("rosettaNetProcessConfiguration", new()
 *     {
 *         ActivitySettings = new AzureNative.Logic.Inputs.RosettaNetPipActivitySettingsArgs
 *         {
 *             AcknowledgmentOfReceiptSettings = new AzureNative.Logic.Inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs
 *             {
 *                 IsNonRepudiationRequired = false,
 *                 TimeToAcknowledgeInSeconds = 600,
 *             },
 *             ActivityBehavior = new AzureNative.Logic.Inputs.RosettaNetPipActivityBehaviorArgs
 *             {
 *                 ActionType = AzureNative.Logic.RosettaNetActionType.DoubleAction,
 *                 IsAuthorizationRequired = false,
 *                 IsSecuredTransportRequired = false,
 *                 NonRepudiationOfOriginAndContent = false,
 *                 PersistentConfidentialityScope = AzureNative.Logic.RosettaNetPipConfidentialityScope.None,
 *                 ResponseType = AzureNative.Logic.RosettaNetResponseType.Async,
 *                 RetryCount = 2,
 *                 TimeToPerformInSeconds = 7200,
 *             },
 *             ActivityType = AzureNative.Logic.RosettaNetPipActivityType.RequestResponse,
 *         },
 *         Description = "Test description",
 *         InitiatorRoleSettings = new AzureNative.Logic.Inputs.RosettaNetPipRoleSettingsArgs
 *         {
 *             Action = "Purchase Order Request",
 *             BusinessDocument = new AzureNative.Logic.Inputs.RosettaNetPipBusinessDocumentArgs
 *             {
 *                 Description = "A request to accept a purchase order for fulfillment..",
 *                 Name = "Purchase Order Request",
 *                 Version = "V02.02.00",
 *             },
 *             Description = "This partner role creates a demand for a product or service.",
 *             Role = "Buyer",
 *             RoleType = AzureNative.Logic.RosettaNetPipRoleType.Functional,
 *             Service = "Buyer Service",
 *             ServiceClassification = "Business Service",
 *         },
 *         IntegrationAccountName = "testia123",
 *         ProcessCode = "3A4",
 *         ProcessName = "Request Purchase Order",
 *         ProcessVersion = "V02.02.00",
 *         ResourceGroupName = "testrg123",
 *         ResponderRoleSettings = new AzureNative.Logic.Inputs.RosettaNetPipRoleSettingsArgs
 *         {
 *             Action = "Purchase Order Confirmation Action",
 *             BusinessDocument = new AzureNative.Logic.Inputs.RosettaNetPipBusinessDocumentArgs
 *             {
 *                 Description = "Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending.",
 *                 Name = "Purchase Order Confirmation",
 *                 Version = "V02.02.00",
 *             },
 *             Description = "An organization that sells products to partners in the supply chain.",
 *             Role = "Seller",
 *             RoleType = AzureNative.Logic.RosettaNetPipRoleType.Organizational,
 *             Service = "Seller Service",
 *             ServiceClassification = "Business Service",
 *         },
 *         RosettaNetProcessConfigurationName = "3A4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewRosettaNetProcessConfiguration(ctx, "rosettaNetProcessConfiguration", &logic.RosettaNetProcessConfigurationArgs{
 * 			ActivitySettings: &logic.RosettaNetPipActivitySettingsArgs{
 * 				AcknowledgmentOfReceiptSettings: &logic.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs{
 * 					IsNonRepudiationRequired:   pulumi.Bool(false),
 * 					TimeToAcknowledgeInSeconds: pulumi.Int(600),
 * 				},
 * 				ActivityBehavior: &logic.RosettaNetPipActivityBehaviorArgs{
 * 					ActionType:                       logic.RosettaNetActionTypeDoubleAction,
 * 					IsAuthorizationRequired:          pulumi.Bool(false),
 * 					IsSecuredTransportRequired:       pulumi.Bool(false),
 * 					NonRepudiationOfOriginAndContent: pulumi.Bool(false),
 * 					PersistentConfidentialityScope:   logic.RosettaNetPipConfidentialityScopeNone,
 * 					ResponseType:                     logic.RosettaNetResponseTypeAsync,
 * 					RetryCount:                       pulumi.Int(2),
 * 					TimeToPerformInSeconds:           pulumi.Int(7200),
 * 				},
 * 				ActivityType: logic.RosettaNetPipActivityTypeRequestResponse,
 * 			},
 * 			Description: pulumi.String("Test description"),
 * 			InitiatorRoleSettings: &logic.RosettaNetPipRoleSettingsArgs{
 * 				Action: pulumi.String("Purchase Order Request"),
 * 				BusinessDocument: &logic.RosettaNetPipBusinessDocumentArgs{
 * 					Description: pulumi.String("A request to accept a purchase order for fulfillment.."),
 * 					Name:        pulumi.String("Purchase Order Request"),
 * 					Version:     pulumi.String("V02.02.00"),
 * 				},
 * 				Description:           pulumi.String("This partner role creates a demand for a product or service."),
 * 				Role:                  pulumi.String("Buyer"),
 * 				RoleType:              logic.RosettaNetPipRoleTypeFunctional,
 * 				Service:               pulumi.String("Buyer Service"),
 * 				ServiceClassification: pulumi.String("Business Service"),
 * 			},
 * 			IntegrationAccountName: pulumi.String("testia123"),
 * 			ProcessCode:            pulumi.String("3A4"),
 * 			ProcessName:            pulumi.String("Request Purchase Order"),
 * 			ProcessVersion:         pulumi.String("V02.02.00"),
 * 			ResourceGroupName:      pulumi.String("testrg123"),
 * 			ResponderRoleSettings: &logic.RosettaNetPipRoleSettingsArgs{
 * 				Action: pulumi.String("Purchase Order Confirmation Action"),
 * 				BusinessDocument: &logic.RosettaNetPipBusinessDocumentArgs{
 * 					Description: pulumi.String("Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending."),
 * 					Name:        pulumi.String("Purchase Order Confirmation"),
 * 					Version:     pulumi.String("V02.02.00"),
 * 				},
 * 				Description:           pulumi.String("An organization that sells products to partners in the supply chain."),
 * 				Role:                  pulumi.String("Seller"),
 * 				RoleType:              logic.RosettaNetPipRoleTypeOrganizational,
 * 				Service:               pulumi.String("Seller Service"),
 * 				ServiceClassification: pulumi.String("Business Service"),
 * 			},
 * 			RosettaNetProcessConfigurationName: pulumi.String("3A4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.RosettaNetProcessConfiguration;
 * import com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivitySettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipAcknowledgmentOfReceiptSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipActivityBehaviorArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs;
 * import com.pulumi.azurenative.logic.inputs.RosettaNetPipBusinessDocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rosettaNetProcessConfiguration = new RosettaNetProcessConfiguration("rosettaNetProcessConfiguration", RosettaNetProcessConfigurationArgs.builder()
 *             .activitySettings(RosettaNetPipActivitySettingsArgs.builder()
 *                 .acknowledgmentOfReceiptSettings(RosettaNetPipAcknowledgmentOfReceiptSettingsArgs.builder()
 *                     .isNonRepudiationRequired(false)
 *                     .timeToAcknowledgeInSeconds(600)
 *                     .build())
 *                 .activityBehavior(RosettaNetPipActivityBehaviorArgs.builder()
 *                     .actionType("DoubleAction")
 *                     .isAuthorizationRequired(false)
 *                     .isSecuredTransportRequired(false)
 *                     .nonRepudiationOfOriginAndContent(false)
 *                     .persistentConfidentialityScope("None")
 *                     .responseType("Async")
 *                     .retryCount(2)
 *                     .timeToPerformInSeconds(7200)
 *                     .build())
 *                 .activityType("RequestResponse")
 *                 .build())
 *             .description("Test description")
 *             .initiatorRoleSettings(RosettaNetPipRoleSettingsArgs.builder()
 *                 .action("Purchase Order Request")
 *                 .businessDocument(RosettaNetPipBusinessDocumentArgs.builder()
 *                     .description("A request to accept a purchase order for fulfillment..")
 *                     .name("Purchase Order Request")
 *                     .version("V02.02.00")
 *                     .build())
 *                 .description("This partner role creates a demand for a product or service.")
 *                 .role("Buyer")
 *                 .roleType("Functional")
 *                 .service("Buyer Service")
 *                 .serviceClassification("Business Service")
 *                 .build())
 *             .integrationAccountName("testia123")
 *             .processCode("3A4")
 *             .processName("Request Purchase Order")
 *             .processVersion("V02.02.00")
 *             .resourceGroupName("testrg123")
 *             .responderRoleSettings(RosettaNetPipRoleSettingsArgs.builder()
 *                 .action("Purchase Order Confirmation Action")
 *                 .businessDocument(RosettaNetPipBusinessDocumentArgs.builder()
 *                     .description("Formally confirms the status of line item(s) in a Purchase Order. A Purchase Order line item may have one of the following states: accepted, rejected, or pending.")
 *                     .name("Purchase Order Confirmation")
 *                     .version("V02.02.00")
 *                     .build())
 *                 .description("An organization that sells products to partners in the supply chain.")
 *                 .role("Seller")
 *                 .roleType("Organizational")
 *                 .service("Seller Service")
 *                 .serviceClassification("Business Service")
 *                 .build())
 *             .rosettaNetProcessConfigurationName("3A4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:RosettaNetProcessConfiguration 3A4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/rosettanetprocessconfigurations/{rosettaNetProcessConfigurationName}
 * ```
 * @property activitySettings The RosettaNet process configuration activity settings.
 * @property description The integration account RosettaNet ProcessConfiguration properties.
 * @property initiatorRoleSettings The RosettaNet initiator role settings.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property processCode The integration account RosettaNet process code.
 * @property processName The integration account RosettaNet process name.
 * @property processVersion The integration account RosettaNet process version.
 * @property resourceGroupName The resource group name.
 * @property responderRoleSettings The RosettaNet responder role settings.
 * @property rosettaNetProcessConfigurationName The integration account RosettaNet ProcessConfiguration name.
 * @property tags The resource tags.
 */
public data class RosettaNetProcessConfigurationArgs(
    public val activitySettings: Output<RosettaNetPipActivitySettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val initiatorRoleSettings: Output<RosettaNetPipRoleSettingsArgs>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val processCode: Output<String>? = null,
    public val processName: Output<String>? = null,
    public val processVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val responderRoleSettings: Output<RosettaNetPipRoleSettingsArgs>? = null,
    public val rosettaNetProcessConfigurationName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs =
        com.pulumi.azurenative.logic.RosettaNetProcessConfigurationArgs.builder()
            .activitySettings(activitySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .initiatorRoleSettings(
                initiatorRoleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .processCode(processCode?.applyValue({ args0 -> args0 }))
            .processName(processName?.applyValue({ args0 -> args0 }))
            .processVersion(processVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .responderRoleSettings(
                responderRoleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rosettaNetProcessConfigurationName(
                rosettaNetProcessConfigurationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RosettaNetProcessConfigurationArgs].
 */
@PulumiTagMarker
public class RosettaNetProcessConfigurationArgsBuilder internal constructor() {
    private var activitySettings: Output<RosettaNetPipActivitySettingsArgs>? = null

    private var description: Output<String>? = null

    private var initiatorRoleSettings: Output<RosettaNetPipRoleSettingsArgs>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var processCode: Output<String>? = null

    private var processName: Output<String>? = null

    private var processVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var responderRoleSettings: Output<RosettaNetPipRoleSettingsArgs>? = null

    private var rosettaNetProcessConfigurationName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The RosettaNet process configuration activity settings.
     */
    @JvmName("obtrsbwxttxebkgt")
    public suspend fun activitySettings(`value`: Output<RosettaNetPipActivitySettingsArgs>) {
        this.activitySettings = value
    }

    /**
     * @param value The integration account RosettaNet ProcessConfiguration properties.
     */
    @JvmName("ruuvljmqovdkyjqw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The RosettaNet initiator role settings.
     */
    @JvmName("vuhnhofaenemfqlc")
    public suspend fun initiatorRoleSettings(`value`: Output<RosettaNetPipRoleSettingsArgs>) {
        this.initiatorRoleSettings = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("uwpsvqtnabvdehmc")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("mbbxvgiweakookol")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("spxhobfubblrxccl")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The integration account RosettaNet process code.
     */
    @JvmName("bujslgskaqwasrpx")
    public suspend fun processCode(`value`: Output<String>) {
        this.processCode = value
    }

    /**
     * @param value The integration account RosettaNet process name.
     */
    @JvmName("pynqudlivhokveip")
    public suspend fun processName(`value`: Output<String>) {
        this.processName = value
    }

    /**
     * @param value The integration account RosettaNet process version.
     */
    @JvmName("vlpvlxbwtcgxllqg")
    public suspend fun processVersion(`value`: Output<String>) {
        this.processVersion = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qdhgmggmardsaywy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The RosettaNet responder role settings.
     */
    @JvmName("ivitdvufhhhqhglu")
    public suspend fun responderRoleSettings(`value`: Output<RosettaNetPipRoleSettingsArgs>) {
        this.responderRoleSettings = value
    }

    /**
     * @param value The integration account RosettaNet ProcessConfiguration name.
     */
    @JvmName("sutkdphbksoanxff")
    public suspend fun rosettaNetProcessConfigurationName(`value`: Output<String>) {
        this.rosettaNetProcessConfigurationName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("yqgldeadmpnenqke")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The RosettaNet process configuration activity settings.
     */
    @JvmName("cnrtgwrlcewqruii")
    public suspend fun activitySettings(`value`: RosettaNetPipActivitySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activitySettings = mapped
    }

    /**
     * @param argument The RosettaNet process configuration activity settings.
     */
    @JvmName("wrwoyhalugcwfrvj")
    public suspend
    fun activitySettings(argument: suspend RosettaNetPipActivitySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipActivitySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.activitySettings = mapped
    }

    /**
     * @param value The integration account RosettaNet ProcessConfiguration properties.
     */
    @JvmName("gbgolqewccomcpwy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The RosettaNet initiator role settings.
     */
    @JvmName("wfdisryqhsfdyaxy")
    public suspend fun initiatorRoleSettings(`value`: RosettaNetPipRoleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initiatorRoleSettings = mapped
    }

    /**
     * @param argument The RosettaNet initiator role settings.
     */
    @JvmName("whbhvoupcqpfdbcv")
    public suspend
    fun initiatorRoleSettings(argument: suspend RosettaNetPipRoleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipRoleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.initiatorRoleSettings = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("yngblhuxtwqoutgf")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("gfewajtxjwmyaiog")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("inrmuqaoxhvmxeow")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values The metadata.
     */
    @JvmName("vygqqwvqlopxfvir")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The integration account RosettaNet process code.
     */
    @JvmName("qmntballqprrjdht")
    public suspend fun processCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processCode = mapped
    }

    /**
     * @param value The integration account RosettaNet process name.
     */
    @JvmName("esrbgljvlbbmcfol")
    public suspend fun processName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processName = mapped
    }

    /**
     * @param value The integration account RosettaNet process version.
     */
    @JvmName("ukboxyljxpgfhypd")
    public suspend fun processVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processVersion = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qlnvuvkscmbujgvm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The RosettaNet responder role settings.
     */
    @JvmName("dwvdrugaiksefnhx")
    public suspend fun responderRoleSettings(`value`: RosettaNetPipRoleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responderRoleSettings = mapped
    }

    /**
     * @param argument The RosettaNet responder role settings.
     */
    @JvmName("cswgbceviuwqxydj")
    public suspend
    fun responderRoleSettings(argument: suspend RosettaNetPipRoleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipRoleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.responderRoleSettings = mapped
    }

    /**
     * @param value The integration account RosettaNet ProcessConfiguration name.
     */
    @JvmName("xtjtbetnlnscybey")
    public suspend fun rosettaNetProcessConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rosettaNetProcessConfigurationName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("emvjfdnnpppsfpir")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("ebhfbrvqrumrgbbx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RosettaNetProcessConfigurationArgs = RosettaNetProcessConfigurationArgs(
        activitySettings = activitySettings,
        description = description,
        initiatorRoleSettings = initiatorRoleSettings,
        integrationAccountName = integrationAccountName,
        location = location,
        metadata = metadata,
        processCode = processCode,
        processName = processName,
        processVersion = processVersion,
        resourceGroupName = resourceGroupName,
        responderRoleSettings = responderRoleSettings,
        rosettaNetProcessConfigurationName = rosettaNetProcessConfigurationName,
        tags = tags,
    )
}
