@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationResponse
import com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsConfigurationResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.logic.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.logic.kotlin.outputs.WorkflowParameterResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationResponse.Companion.toKotlin as flowAccessControlConfigurationResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsConfigurationResponse.Companion.toKotlin as flowEndpointsConfigurationResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.WorkflowParameterResponse.Companion.toKotlin as workflowParameterResponseToKotlin

/**
 * Builder for [Workflow].
 */
@PulumiTagMarker
public class WorkflowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkflowArgs = WorkflowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkflowArgsBuilder.() -> Unit) {
        val builder = WorkflowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workflow {
        val builtJavaResource = com.pulumi.azurenative.logic.Workflow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workflow(builtJavaResource)
    }
}

/**
 * The workflow type.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-02-01-preview, 2016-06-01, 2018-07-01-preview.
 * ## Example Usage
 * ### Create or update a workflow
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.Logic.Workflow("workflow", new()
 *     {
 *         Definition = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
 *             ["actions"] = new Dictionary<string, object?>
 *             {
 *                 ["Find_pet_by_ID"] = new Dictionary<string, object?>
 *                 {
 *                     ["inputs"] = new Dictionary<string, object?>
 *                     {
 *                         ["host"] = new Dictionary<string, object?>
 *                         {
 *                             ["connection"] = new Dictionary<string, object?>
 *                             {
 *                                 ["name"] = "@parameters('$connections')['test-custom-connector']['connectionId']",
 *                             },
 *                         },
 *                         ["method"] = "get",
 *                         ["path"] = "/pet/@{encodeURIComponent('1')}",
 *                     },
 *                     ["runAfter"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["type"] = "ApiConnection",
 *                 },
 *             },
 *             ["contentVersion"] = "1.0.0.0",
 *             ["outputs"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["$connections"] = new Dictionary<string, object?>
 *                 {
 *                     ["defaultValue"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["type"] = "Object",
 *                 },
 *             },
 *             ["triggers"] = new Dictionary<string, object?>
 *             {
 *                 ["manual"] = new Dictionary<string, object?>
 *                 {
 *                     ["inputs"] = new Dictionary<string, object?>
 *                     {
 *                         ["schema"] = new Dictionary<string, object?>
 *                         {
 *                         },
 *                     },
 *                     ["kind"] = "Http",
 *                     ["type"] = "Request",
 *                 },
 *             },
 *         },
 *         IntegrationAccount = new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account",
 *         },
 *         Location = "brazilsouth",
 *         Parameters =
 *         {
 *             { "$connections", new AzureNative.Logic.Inputs.WorkflowParameterArgs
 *             {
 *                 Value = new Dictionary<string, object?>
 *                 {
 *                     ["test-custom-connector"] = new Dictionary<string, object?>
 *                     {
 *                         ["connectionId"] = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector",
 *                         ["connectionName"] = "test-custom-connector",
 *                         ["id"] = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector",
 *                     },
 *                 },
 *             } },
 *         },
 *         ResourceGroupName = "test-resource-group",
 *         Tags = null,
 *         WorkflowName = "test-workflow",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewWorkflow(ctx, "workflow", &logic.WorkflowArgs{
 * 			Definition: pulumi.Any(map[string]interface{}{
 * 				"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
 * 				"actions": map[string]interface{}{
 * 					"Find_pet_by_ID": map[string]interface{}{
 * 						"inputs": map[string]interface{}{
 * 							"host": map[string]interface{}{
 * 								"connection": map[string]interface{}{
 * 									"name": "@parameters('$connections')['test-custom-connector']['connectionId']",
 * 								},
 * 							},
 * 							"method": "get",
 * 							"path":   "/pet/@{encodeURIComponent('1')}",
 * 						},
 * 						"runAfter": nil,
 * 						"type":     "ApiConnection",
 * 					},
 * 				},
 * 				"contentVersion": "1.0.0.0",
 * 				"outputs":        nil,
 * 				"parameters": map[string]interface{}{
 * 					"$connections": map[string]interface{}{
 * 						"defaultValue": nil,
 * 						"type":         "Object",
 * 					},
 * 				},
 * 				"triggers": map[string]interface{}{
 * 					"manual": map[string]interface{}{
 * 						"inputs": map[string]interface{}{
 * 							"schema": nil,
 * 						},
 * 						"kind": "Http",
 * 						"type": "Request",
 * 					},
 * 				},
 * 			}),
 * 			IntegrationAccount: &logic.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
 * 			},
 * 			Location: pulumi.String("brazilsouth"),
 * 			Parameters: logic.WorkflowParameterMap{
 * 				"$connections": &logic.WorkflowParameterArgs{
 * 					Value: pulumi.Any(map[string]interface{}{
 * 						"test-custom-connector": map[string]interface{}{
 * 							"connectionId":   "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector",
 * 							"connectionName": "test-custom-connector",
 * 							"id":             "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector",
 * 						},
 * 					}),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-resource-group"),
 * 			Tags:              nil,
 * 			WorkflowName:      pulumi.String("test-workflow"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.Workflow;
 * import com.pulumi.azurenative.logic.WorkflowArgs;
 * import com.pulumi.azurenative.logic.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("$schema", "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#"),
 *                 Map.entry("actions", Map.of("Find_pet_by_ID", Map.ofEntries(
 *                     Map.entry("inputs", Map.ofEntries(
 *                         Map.entry("host", Map.of("connection", Map.of("name", "@parameters('$connections')['test-custom-connector']['connectionId']"))),
 *                         Map.entry("method", "get"),
 *                         Map.entry("path", "/pet/@{encodeURIComponent('1')}")
 *                     )),
 *                     Map.entry("runAfter", ),
 *                     Map.entry("type", "ApiConnection")
 *                 ))),
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", ),
 *                 Map.entry("parameters", Map.of("$connections", Map.ofEntries(
 *                     Map.entry("defaultValue", ),
 *                     Map.entry("type", "Object")
 *                 ))),
 *                 Map.entry("triggers", Map.of("manual", Map.ofEntries(
 *                     Map.entry("inputs", Map.of("schema", )),
 *                     Map.entry("kind", "Http"),
 *                     Map.entry("type", "Request")
 *                 )))
 *             ))
 *             .integrationAccount(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account")
 *                 .build())
 *             .location("brazilsouth")
 *             .parameters(Map.of("$connections", Map.of("value", Map.of("test-custom-connector", Map.ofEntries(
 *                 Map.entry("connectionId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector"),
 *                 Map.entry("connectionName", "test-custom-connector"),
 *                 Map.entry("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector")
 *             )))))
 *             .resourceGroupName("test-resource-group")
 *             .tags()
 *             .workflowName("test-workflow")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:Workflow myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}
 * ```
 */
public class Workflow internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.Workflow,
) : KotlinCustomResource(javaResource, WorkflowMapper) {
    /**
     * The access control configuration.
     */
    public val accessControl: Output<FlowAccessControlConfigurationResponse>?
        get() = javaResource.accessControl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> flowAccessControlConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the access endpoint.
     */
    public val accessEndpoint: Output<String>
        get() = javaResource.accessEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets the changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * Gets the created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The definition.
     */
    public val definition: Output<Any>?
        get() = javaResource.definition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The endpoints configuration.
     */
    public val endpointsConfiguration: Output<FlowEndpointsConfigurationResponse>?
        get() = javaResource.endpointsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> flowEndpointsConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Managed service identity properties.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The integration account.
     */
    public val integrationAccount: Output<ResourceReferenceResponse>?
        get() = javaResource.integrationAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The integration service environment.
     */
    public val integrationServiceEnvironment: Output<ResourceReferenceResponse>?
        get() = javaResource.integrationServiceEnvironment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters.
     */
    public val parameters: Output<Map<String, WorkflowParameterResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            workflowParameterResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The sku.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The state.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object WorkflowMapper : ResourceMapper<Workflow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.Workflow::class == javaResource::class

    override fun map(javaResource: Resource): Workflow = Workflow(
        javaResource as
            com.pulumi.azurenative.logic.Workflow,
    )
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workflow].
 */
public suspend fun workflow(name: String, block: suspend WorkflowResourceBuilder.() -> Unit):
    Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workflow(name: String): Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    return builder.build()
}
