@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkflowAccessKey].
 */
@PulumiTagMarker
public class WorkflowAccessKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkflowAccessKeyArgs = WorkflowAccessKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkflowAccessKeyArgsBuilder.() -> Unit) {
        val builder = WorkflowAccessKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkflowAccessKey {
        val builtJavaResource = com.pulumi.azurenative.logic.WorkflowAccessKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkflowAccessKey(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2015-02-01-preview. Prior API version in Azure Native 1.x: 2015-02-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:WorkflowAccessKey myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}
 * ```
 */
public class WorkflowAccessKey internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.WorkflowAccessKey,
) : KotlinCustomResource(javaResource, WorkflowAccessKeyMapper) {
    /**
     * Gets the workflow access key name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the not-after time.
     */
    public val notAfter: Output<String>?
        get() = javaResource.notAfter().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the not-before time.
     */
    public val notBefore: Output<String>?
        get() = javaResource.notBefore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the workflow access key type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkflowAccessKeyMapper : ResourceMapper<WorkflowAccessKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.WorkflowAccessKey::class == javaResource::class

    override fun map(javaResource: Resource): WorkflowAccessKey = WorkflowAccessKey(
        javaResource as
            com.pulumi.azurenative.logic.WorkflowAccessKey,
    )
}

/**
 * @see [WorkflowAccessKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkflowAccessKey].
 */
public suspend fun workflowAccessKey(
    name: String,
    block: suspend WorkflowAccessKeyResourceBuilder.() -> Unit,
): WorkflowAccessKey {
    val builder = WorkflowAccessKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkflowAccessKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workflowAccessKey(name: String): WorkflowAccessKey {
    val builder = WorkflowAccessKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
