@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.WorkflowArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.WorkflowState
import com.pulumi.azurenative.logic.kotlin.inputs.FlowAccessControlConfigurationArgs
import com.pulumi.azurenative.logic.kotlin.inputs.FlowAccessControlConfigurationArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.FlowEndpointsConfigurationArgs
import com.pulumi.azurenative.logic.kotlin.inputs.FlowEndpointsConfigurationArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.WorkflowParameterArgs
import com.pulumi.azurenative.logic.kotlin.inputs.WorkflowParameterArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The workflow type.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-02-01-preview, 2016-06-01, 2018-07-01-preview.
 * ## Example Usage
 * ### Create or update a workflow
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.Logic.Workflow("workflow", new()
 *     {
 *         Definition = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
 *             ["actions"] = new Dictionary<string, object?>
 *             {
 *                 ["Find_pet_by_ID"] = new Dictionary<string, object?>
 *                 {
 *                     ["inputs"] = new Dictionary<string, object?>
 *                     {
 *                         ["host"] = new Dictionary<string, object?>
 *                         {
 *                             ["connection"] = new Dictionary<string, object?>
 *                             {
 *                                 ["name"] = "@parameters('$connections')['test-custom-connector']['connectionId']",
 *                             },
 *                         },
 *                         ["method"] = "get",
 *                         ["path"] = "/pet/@{encodeURIComponent('1')}",
 *                     },
 *                     ["runAfter"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["type"] = "ApiConnection",
 *                 },
 *             },
 *             ["contentVersion"] = "1.0.0.0",
 *             ["outputs"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *                 ["$connections"] = new Dictionary<string, object?>
 *                 {
 *                     ["defaultValue"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["type"] = "Object",
 *                 },
 *             },
 *             ["triggers"] = new Dictionary<string, object?>
 *             {
 *                 ["manual"] = new Dictionary<string, object?>
 *                 {
 *                     ["inputs"] = new Dictionary<string, object?>
 *                     {
 *                         ["schema"] = new Dictionary<string, object?>
 *                         {
 *                         },
 *                     },
 *                     ["kind"] = "Http",
 *                     ["type"] = "Request",
 *                 },
 *             },
 *         },
 *         IntegrationAccount = new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *         {
 *             Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account",
 *         },
 *         Location = "brazilsouth",
 *         Parameters =
 *         {
 *             { "$connections", new AzureNative.Logic.Inputs.WorkflowParameterArgs
 *             {
 *                 Value = new Dictionary<string, object?>
 *                 {
 *                     ["test-custom-connector"] = new Dictionary<string, object?>
 *                     {
 *                         ["connectionId"] = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector",
 *                         ["connectionName"] = "test-custom-connector",
 *                         ["id"] = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector",
 *                     },
 *                 },
 *             } },
 *         },
 *         ResourceGroupName = "test-resource-group",
 *         Tags = null,
 *         WorkflowName = "test-workflow",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewWorkflow(ctx, "workflow", &logic.WorkflowArgs{
 * 			Definition: pulumi.Any(map[string]interface{}{
 * 				"$schema": "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#",
 * 				"actions": map[string]interface{}{
 * 					"Find_pet_by_ID": map[string]interface{}{
 * 						"inputs": map[string]interface{}{
 * 							"host": map[string]interface{}{
 * 								"connection": map[string]interface{}{
 * 									"name": "@parameters('$connections')['test-custom-connector']['connectionId']",
 * 								},
 * 							},
 * 							"method": "get",
 * 							"path":   "/pet/@{encodeURIComponent('1')}",
 * 						},
 * 						"runAfter": nil,
 * 						"type":     "ApiConnection",
 * 					},
 * 				},
 * 				"contentVersion": "1.0.0.0",
 * 				"outputs":        nil,
 * 				"parameters": map[string]interface{}{
 * 					"$connections": map[string]interface{}{
 * 						"defaultValue": nil,
 * 						"type":         "Object",
 * 					},
 * 				},
 * 				"triggers": map[string]interface{}{
 * 					"manual": map[string]interface{}{
 * 						"inputs": map[string]interface{}{
 * 							"schema": nil,
 * 						},
 * 						"kind": "Http",
 * 						"type": "Request",
 * 					},
 * 				},
 * 			}),
 * 			IntegrationAccount: &logic.ResourceReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account"),
 * 			},
 * 			Location: pulumi.String("brazilsouth"),
 * 			Parameters: logic.WorkflowParameterMap{
 * 				"$connections": &logic.WorkflowParameterArgs{
 * 					Value: pulumi.Any(map[string]interface{}{
 * 						"test-custom-connector": map[string]interface{}{
 * 							"connectionId":   "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector",
 * 							"connectionName": "test-custom-connector",
 * 							"id":             "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector",
 * 						},
 * 					}),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("test-resource-group"),
 * 			Tags:              nil,
 * 			WorkflowName:      pulumi.String("test-workflow"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.Workflow;
 * import com.pulumi.azurenative.logic.WorkflowArgs;
 * import com.pulumi.azurenative.logic.inputs.ResourceReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .definition(Map.ofEntries(
 *                 Map.entry("$schema", "https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#"),
 *                 Map.entry("actions", Map.of("Find_pet_by_ID", Map.ofEntries(
 *                     Map.entry("inputs", Map.ofEntries(
 *                         Map.entry("host", Map.of("connection", Map.of("name", "@parameters('$connections')['test-custom-connector']['connectionId']"))),
 *                         Map.entry("method", "get"),
 *                         Map.entry("path", "/pet/@{encodeURIComponent('1')}")
 *                     )),
 *                     Map.entry("runAfter", ),
 *                     Map.entry("type", "ApiConnection")
 *                 ))),
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("outputs", ),
 *                 Map.entry("parameters", Map.of("$connections", Map.ofEntries(
 *                     Map.entry("defaultValue", ),
 *                     Map.entry("type", "Object")
 *                 ))),
 *                 Map.entry("triggers", Map.of("manual", Map.ofEntries(
 *                     Map.entry("inputs", Map.of("schema", )),
 *                     Map.entry("kind", "Http"),
 *                     Map.entry("type", "Request")
 *                 )))
 *             ))
 *             .integrationAccount(ResourceReferenceArgs.builder()
 *                 .id("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Logic/integrationAccounts/test-integration-account")
 *                 .build())
 *             .location("brazilsouth")
 *             .parameters(Map.of("$connections", Map.of("value", Map.of("test-custom-connector", Map.ofEntries(
 *                 Map.entry("connectionId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-resource-group/providers/Microsoft.Web/connections/test-custom-connector"),
 *                 Map.entry("connectionName", "test-custom-connector"),
 *                 Map.entry("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/providers/Microsoft.Web/locations/brazilsouth/managedApis/test-custom-connector")
 *             )))))
 *             .resourceGroupName("test-resource-group")
 *             .tags()
 *             .workflowName("test-workflow")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:Workflow myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}
 * ```
 * @property accessControl The access control configuration.
 * @property definition The definition.
 * @property endpointsConfiguration The endpoints configuration.
 * @property identity Managed service identity properties.
 * @property integrationAccount The integration account.
 * @property integrationServiceEnvironment The integration service environment.
 * @property location The resource location.
 * @property parameters The parameters.
 * @property resourceGroupName The resource group name.
 * @property state The state.
 * @property tags The resource tags.
 * @property workflowName The workflow name.
 */
public data class WorkflowArgs(
    public val accessControl: Output<FlowAccessControlConfigurationArgs>? = null,
    public val definition: Output<Any>? = null,
    public val endpointsConfiguration: Output<FlowEndpointsConfigurationArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val integrationAccount: Output<ResourceReferenceArgs>? = null,
    public val integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val parameters: Output<Map<String, WorkflowParameterArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, WorkflowState>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workflowName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.WorkflowArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.WorkflowArgs =
        com.pulumi.azurenative.logic.WorkflowArgs.builder()
            .accessControl(accessControl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .definition(definition?.applyValue({ args0 -> args0 }))
            .endpointsConfiguration(
                endpointsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integrationAccount(
                integrationAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .integrationServiceEnvironment(
                integrationServiceEnvironment?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workflowName(workflowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var accessControl: Output<FlowAccessControlConfigurationArgs>? = null

    private var definition: Output<Any>? = null

    private var endpointsConfiguration: Output<FlowEndpointsConfigurationArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var integrationAccount: Output<ResourceReferenceArgs>? = null

    private var integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null

    private var location: Output<String>? = null

    private var parameters: Output<Map<String, WorkflowParameterArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, WorkflowState>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workflowName: Output<String>? = null

    /**
     * @param value The access control configuration.
     */
    @JvmName("rewjpckpicmngkht")
    public suspend fun accessControl(`value`: Output<FlowAccessControlConfigurationArgs>) {
        this.accessControl = value
    }

    /**
     * @param value The definition.
     */
    @JvmName("ogocowatejylafiw")
    public suspend fun definition(`value`: Output<Any>) {
        this.definition = value
    }

    /**
     * @param value The endpoints configuration.
     */
    @JvmName("gptxbtqtvwnmpgug")
    public suspend fun endpointsConfiguration(`value`: Output<FlowEndpointsConfigurationArgs>) {
        this.endpointsConfiguration = value
    }

    /**
     * @param value Managed service identity properties.
     */
    @JvmName("glutpjjlvfcrbide")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The integration account.
     */
    @JvmName("nfoxlwhhhxsfocxg")
    public suspend fun integrationAccount(`value`: Output<ResourceReferenceArgs>) {
        this.integrationAccount = value
    }

    /**
     * @param value The integration service environment.
     */
    @JvmName("agbtpmuopsvdgcrq")
    public suspend fun integrationServiceEnvironment(`value`: Output<ResourceReferenceArgs>) {
        this.integrationServiceEnvironment = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("gdgyhonggtgufjlg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The parameters.
     */
    @JvmName("mxqgiydxadpfqlni")
    public suspend fun parameters(`value`: Output<Map<String, WorkflowParameterArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yncvmvcjwjenhxdc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The state.
     */
    @JvmName("gsvpkhpqcubcliro")
    public suspend fun state(`value`: Output<Either<String, WorkflowState>>) {
        this.state = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("psfaqdvvfhwwasrt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("gjixkongfixsryco")
    public suspend fun workflowName(`value`: Output<String>) {
        this.workflowName = value
    }

    /**
     * @param value The access control configuration.
     */
    @JvmName("mcuvuxbhdrnfpxak")
    public suspend fun accessControl(`value`: FlowAccessControlConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControl = mapped
    }

    /**
     * @param argument The access control configuration.
     */
    @JvmName("lclywxlbnqyjjkqf")
    public suspend
    fun accessControl(argument: suspend FlowAccessControlConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FlowAccessControlConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControl = mapped
    }

    /**
     * @param value The definition.
     */
    @JvmName("lfqemxwdowhkahcv")
    public suspend fun definition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value The endpoints configuration.
     */
    @JvmName("juoevgkpjhufmnqq")
    public suspend fun endpointsConfiguration(`value`: FlowEndpointsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointsConfiguration = mapped
    }

    /**
     * @param argument The endpoints configuration.
     */
    @JvmName("ripeshfargaxqqlp")
    public suspend
    fun endpointsConfiguration(argument: suspend FlowEndpointsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FlowEndpointsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointsConfiguration = mapped
    }

    /**
     * @param value Managed service identity properties.
     */
    @JvmName("pscfosemlesejoyb")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity properties.
     */
    @JvmName("mlditspdyfguoans")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The integration account.
     */
    @JvmName("tihthgocyadqtwsw")
    public suspend fun integrationAccount(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccount = mapped
    }

    /**
     * @param argument The integration account.
     */
    @JvmName("uosoypjduajqhfxi")
    public suspend fun integrationAccount(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integrationAccount = mapped
    }

    /**
     * @param value The integration service environment.
     */
    @JvmName("oftaiuyqrsskohip")
    public suspend fun integrationServiceEnvironment(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param argument The integration service environment.
     */
    @JvmName("hlwqqcelpmxdeuws")
    public suspend
    fun integrationServiceEnvironment(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("qlphuxvpagkikxhq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The parameters.
     */
    @JvmName("iuorjcqmldkgaqmw")
    public suspend fun parameters(`value`: Map<String, WorkflowParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters.
     */
    @JvmName("hxvsaxawhfrdixgp")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend WorkflowParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                WorkflowParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters.
     */
    @JvmName("wwfbpwrvmnjhhmnr")
    public fun parameters(vararg values: Pair<String, WorkflowParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lnywsmblhdcompff")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("yiniripbvirwutjc")
    public suspend fun state(`value`: Either<String, WorkflowState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("ofwawvtnejabowiw")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("tlsjfeqoajusxoar")
    public fun state(`value`: WorkflowState) {
        val toBeMapped = Either.ofRight<String, WorkflowState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("kkcmjtdbwgmieapf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("xbofxpauaqupkcod")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("bkxyrptaldctipex")
    public suspend fun workflowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowName = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        accessControl = accessControl,
        definition = definition,
        endpointsConfiguration = endpointsConfiguration,
        identity = identity,
        integrationAccount = integrationAccount,
        integrationServiceEnvironment = integrationServiceEnvironment,
        location = location,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        state = state,
        tags = tags,
        workflowName = workflowName,
    )
}
