@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement envelope settings.
 * @property autogenerateFileName The value indicating whether to auto generate file name.
 * @property fileNameTemplate The template for file name.
 * @property messageContentType The message content type.
 * @property suspendMessageOnFileNameGenerationError The value indicating whether to suspend message on file name generation error.
 * @property transmitFileNameInMimeHeader The value indicating whether to transmit file name in mime header.
 */
public data class AS2EnvelopeSettingsArgs(
    public val autogenerateFileName: Output<Boolean>,
    public val fileNameTemplate: Output<String>,
    public val messageContentType: Output<String>,
    public val suspendMessageOnFileNameGenerationError: Output<Boolean>,
    public val transmitFileNameInMimeHeader: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2EnvelopeSettingsArgs.builder()
            .autogenerateFileName(autogenerateFileName.applyValue({ args0 -> args0 }))
            .fileNameTemplate(fileNameTemplate.applyValue({ args0 -> args0 }))
            .messageContentType(messageContentType.applyValue({ args0 -> args0 }))
            .suspendMessageOnFileNameGenerationError(
                suspendMessageOnFileNameGenerationError.applyValue({ args0 ->
                    args0
                }),
            )
            .transmitFileNameInMimeHeader(transmitFileNameInMimeHeader.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2EnvelopeSettingsArgs].
 */
@PulumiTagMarker
public class AS2EnvelopeSettingsArgsBuilder internal constructor() {
    private var autogenerateFileName: Output<Boolean>? = null

    private var fileNameTemplate: Output<String>? = null

    private var messageContentType: Output<String>? = null

    private var suspendMessageOnFileNameGenerationError: Output<Boolean>? = null

    private var transmitFileNameInMimeHeader: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to auto generate file name.
     */
    @JvmName("bxyqoangbhwmnosa")
    public suspend fun autogenerateFileName(`value`: Output<Boolean>) {
        this.autogenerateFileName = value
    }

    /**
     * @param value The template for file name.
     */
    @JvmName("kbqdfujqddaggtxl")
    public suspend fun fileNameTemplate(`value`: Output<String>) {
        this.fileNameTemplate = value
    }

    /**
     * @param value The message content type.
     */
    @JvmName("vqietcpqmxrbadpo")
    public suspend fun messageContentType(`value`: Output<String>) {
        this.messageContentType = value
    }

    /**
     * @param value The value indicating whether to suspend message on file name generation error.
     */
    @JvmName("fremwtemdcmoedtn")
    public suspend fun suspendMessageOnFileNameGenerationError(`value`: Output<Boolean>) {
        this.suspendMessageOnFileNameGenerationError = value
    }

    /**
     * @param value The value indicating whether to transmit file name in mime header.
     */
    @JvmName("fmlskitiahrirany")
    public suspend fun transmitFileNameInMimeHeader(`value`: Output<Boolean>) {
        this.transmitFileNameInMimeHeader = value
    }

    /**
     * @param value The value indicating whether to auto generate file name.
     */
    @JvmName("dampvoetxrbhgxuj")
    public suspend fun autogenerateFileName(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autogenerateFileName = mapped
    }

    /**
     * @param value The template for file name.
     */
    @JvmName("fkwdqklrifikntof")
    public suspend fun fileNameTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileNameTemplate = mapped
    }

    /**
     * @param value The message content type.
     */
    @JvmName("rnsvmcpwdsbnivjd")
    public suspend fun messageContentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageContentType = mapped
    }

    /**
     * @param value The value indicating whether to suspend message on file name generation error.
     */
    @JvmName("nvaegliulfgnqshd")
    public suspend fun suspendMessageOnFileNameGenerationError(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suspendMessageOnFileNameGenerationError = mapped
    }

    /**
     * @param value The value indicating whether to transmit file name in mime header.
     */
    @JvmName("pwrktfvohykosipe")
    public suspend fun transmitFileNameInMimeHeader(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transmitFileNameInMimeHeader = mapped
    }

    internal fun build(): AS2EnvelopeSettingsArgs = AS2EnvelopeSettingsArgs(
        autogenerateFileName = autogenerateFileName ?: throw
            PulumiNullFieldException("autogenerateFileName"),
        fileNameTemplate = fileNameTemplate ?: throw PulumiNullFieldException("fileNameTemplate"),
        messageContentType = messageContentType ?: throw PulumiNullFieldException("messageContentType"),
        suspendMessageOnFileNameGenerationError = suspendMessageOnFileNameGenerationError ?: throw
            PulumiNullFieldException("suspendMessageOnFileNameGenerationError"),
        transmitFileNameInMimeHeader = transmitFileNameInMimeHeader ?: throw
            PulumiNullFieldException("transmitFileNameInMimeHeader"),
    )
}
