@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement error settings.
 * @property resendIfMDNNotReceived The value indicating whether to resend message If MDN is not received.
 * @property suspendDuplicateMessage The value indicating whether to suspend duplicate message.
 */
public data class AS2ErrorSettingsArgs(
    public val resendIfMDNNotReceived: Output<Boolean>,
    public val suspendDuplicateMessage: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2ErrorSettingsArgs.builder()
            .resendIfMDNNotReceived(resendIfMDNNotReceived.applyValue({ args0 -> args0 }))
            .suspendDuplicateMessage(suspendDuplicateMessage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2ErrorSettingsArgs].
 */
@PulumiTagMarker
public class AS2ErrorSettingsArgsBuilder internal constructor() {
    private var resendIfMDNNotReceived: Output<Boolean>? = null

    private var suspendDuplicateMessage: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to resend message If MDN is not received.
     */
    @JvmName("xvcfgfwydypvwadr")
    public suspend fun resendIfMDNNotReceived(`value`: Output<Boolean>) {
        this.resendIfMDNNotReceived = value
    }

    /**
     * @param value The value indicating whether to suspend duplicate message.
     */
    @JvmName("mggjlficgcuilncf")
    public suspend fun suspendDuplicateMessage(`value`: Output<Boolean>) {
        this.suspendDuplicateMessage = value
    }

    /**
     * @param value The value indicating whether to resend message If MDN is not received.
     */
    @JvmName("raoftavuweubkdew")
    public suspend fun resendIfMDNNotReceived(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resendIfMDNNotReceived = mapped
    }

    /**
     * @param value The value indicating whether to suspend duplicate message.
     */
    @JvmName("vnhrjhoqbptemlda")
    public suspend fun suspendDuplicateMessage(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suspendDuplicateMessage = mapped
    }

    internal fun build(): AS2ErrorSettingsArgs = AS2ErrorSettingsArgs(
        resendIfMDNNotReceived = resendIfMDNNotReceived ?: throw
            PulumiNullFieldException("resendIfMDNNotReceived"),
        suspendDuplicateMessage = suspendDuplicateMessage ?: throw
            PulumiNullFieldException("suspendDuplicateMessage"),
    )
}
