@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration account partner's business identity.
 * @property qualifier The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
 * @property value The user defined business identity value.
 */
public data class BusinessIdentityArgs(
    public val qualifier: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs =
        com.pulumi.azurenative.logic.inputs.BusinessIdentityArgs.builder()
            .qualifier(qualifier.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BusinessIdentityArgs].
 */
@PulumiTagMarker
public class BusinessIdentityArgsBuilder internal constructor() {
    private var qualifier: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
     */
    @JvmName("lprxyswsnmjsaavk")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value The user defined business identity value.
     */
    @JvmName("yytovtlxxsbprgat")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
     */
    @JvmName("qtrmsvuoxuaobdmm")
    public suspend fun qualifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value The user defined business identity value.
     */
    @JvmName("wxfieuiglcqwgmho")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): BusinessIdentityArgs = BusinessIdentityArgs(
        qualifier = qualifier ?: throw PulumiNullFieldException("qualifier"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
