@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactFramingSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.EdifactCharacterSet
import com.pulumi.azurenative.logic.kotlin.enums.EdifactDecimalIndicator
import com.pulumi.azurenative.logic.kotlin.enums.SegmentTerminatorSuffix
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact agreement framing settings.
 * @property characterEncoding The character encoding.
 * @property characterSet The EDIFACT frame setting characterSet.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property decimalPointIndicator The EDIFACT frame setting decimal indicator.
 * @property protocolVersion The protocol version.
 * @property releaseIndicator The release indicator.
 * @property repetitionSeparator The repetition separator.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The EDIFACT frame setting segment terminator suffix.
 * @property serviceCodeListDirectoryVersion The service code list directory version.
 */
public data class EdifactFramingSettingsArgs(
    public val characterEncoding: Output<String>? = null,
    public val characterSet: Output<Either<String, EdifactCharacterSet>>,
    public val componentSeparator: Output<Int>,
    public val dataElementSeparator: Output<Int>,
    public val decimalPointIndicator: Output<EdifactDecimalIndicator>,
    public val protocolVersion: Output<Int>,
    public val releaseIndicator: Output<Int>,
    public val repetitionSeparator: Output<Int>,
    public val segmentTerminator: Output<Int>,
    public val segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>,
    public val serviceCodeListDirectoryVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactFramingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactFramingSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactFramingSettingsArgs.builder()
            .characterEncoding(characterEncoding?.applyValue({ args0 -> args0 }))
            .characterSet(
                characterSet.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .componentSeparator(componentSeparator.applyValue({ args0 -> args0 }))
            .dataElementSeparator(dataElementSeparator.applyValue({ args0 -> args0 }))
            .decimalPointIndicator(
                decimalPointIndicator.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .protocolVersion(protocolVersion.applyValue({ args0 -> args0 }))
            .releaseIndicator(releaseIndicator.applyValue({ args0 -> args0 }))
            .repetitionSeparator(repetitionSeparator.applyValue({ args0 -> args0 }))
            .segmentTerminator(segmentTerminator.applyValue({ args0 -> args0 }))
            .segmentTerminatorSuffix(
                segmentTerminatorSuffix.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceCodeListDirectoryVersion(
                serviceCodeListDirectoryVersion?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EdifactFramingSettingsArgs].
 */
@PulumiTagMarker
public class EdifactFramingSettingsArgsBuilder internal constructor() {
    private var characterEncoding: Output<String>? = null

    private var characterSet: Output<Either<String, EdifactCharacterSet>>? = null

    private var componentSeparator: Output<Int>? = null

    private var dataElementSeparator: Output<Int>? = null

    private var decimalPointIndicator: Output<EdifactDecimalIndicator>? = null

    private var protocolVersion: Output<Int>? = null

    private var releaseIndicator: Output<Int>? = null

    private var repetitionSeparator: Output<Int>? = null

    private var segmentTerminator: Output<Int>? = null

    private var segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>? = null

    private var serviceCodeListDirectoryVersion: Output<String>? = null

    /**
     * @param value The character encoding.
     */
    @JvmName("horcefwjjgkckfnb")
    public suspend fun characterEncoding(`value`: Output<String>) {
        this.characterEncoding = value
    }

    /**
     * @param value The EDIFACT frame setting characterSet.
     */
    @JvmName("jpywatiijfhbupmk")
    public suspend fun characterSet(`value`: Output<Either<String, EdifactCharacterSet>>) {
        this.characterSet = value
    }

    /**
     * @param value The component separator.
     */
    @JvmName("wumrgjwsqxeeewev")
    public suspend fun componentSeparator(`value`: Output<Int>) {
        this.componentSeparator = value
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("vjjibeosyfrkmpdo")
    public suspend fun dataElementSeparator(`value`: Output<Int>) {
        this.dataElementSeparator = value
    }

    /**
     * @param value The EDIFACT frame setting decimal indicator.
     */
    @JvmName("aoecgtexpnwrvdrw")
    public suspend fun decimalPointIndicator(`value`: Output<EdifactDecimalIndicator>) {
        this.decimalPointIndicator = value
    }

    /**
     * @param value The protocol version.
     */
    @JvmName("ncqvlbpxsvqxgqsp")
    public suspend fun protocolVersion(`value`: Output<Int>) {
        this.protocolVersion = value
    }

    /**
     * @param value The release indicator.
     */
    @JvmName("ibubsbpedtyaqnyj")
    public suspend fun releaseIndicator(`value`: Output<Int>) {
        this.releaseIndicator = value
    }

    /**
     * @param value The repetition separator.
     */
    @JvmName("nqadrgpfppbejbey")
    public suspend fun repetitionSeparator(`value`: Output<Int>) {
        this.repetitionSeparator = value
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("udqnvadscqtoxaud")
    public suspend fun segmentTerminator(`value`: Output<Int>) {
        this.segmentTerminator = value
    }

    /**
     * @param value The EDIFACT frame setting segment terminator suffix.
     */
    @JvmName("vwhinrtftymahddo")
    public suspend fun segmentTerminatorSuffix(`value`: Output<SegmentTerminatorSuffix>) {
        this.segmentTerminatorSuffix = value
    }

    /**
     * @param value The service code list directory version.
     */
    @JvmName("ogiqdjocpqbmnert")
    public suspend fun serviceCodeListDirectoryVersion(`value`: Output<String>) {
        this.serviceCodeListDirectoryVersion = value
    }

    /**
     * @param value The character encoding.
     */
    @JvmName("pvrllyadekfrthuy")
    public suspend fun characterEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.characterEncoding = mapped
    }

    /**
     * @param value The EDIFACT frame setting characterSet.
     */
    @JvmName("ftuiftdfghwerqrq")
    public suspend fun characterSet(`value`: Either<String, EdifactCharacterSet>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The EDIFACT frame setting characterSet.
     */
    @JvmName("eshijqtwudmxlyvj")
    public fun characterSet(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EdifactCharacterSet>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The EDIFACT frame setting characterSet.
     */
    @JvmName("mhwwrbrquvmjdhvc")
    public fun characterSet(`value`: EdifactCharacterSet) {
        val toBeMapped = Either.ofRight<String, EdifactCharacterSet>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The component separator.
     */
    @JvmName("pysfapgwxyalxghk")
    public suspend fun componentSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentSeparator = mapped
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("ejnlkrbkpvhslaym")
    public suspend fun dataElementSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataElementSeparator = mapped
    }

    /**
     * @param value The EDIFACT frame setting decimal indicator.
     */
    @JvmName("ehoxqxkwkyxnuekl")
    public suspend fun decimalPointIndicator(`value`: EdifactDecimalIndicator) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decimalPointIndicator = mapped
    }

    /**
     * @param value The protocol version.
     */
    @JvmName("fycxeyhtipiktcav")
    public suspend fun protocolVersion(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value The release indicator.
     */
    @JvmName("yoisrvbmvdcwijth")
    public suspend fun releaseIndicator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.releaseIndicator = mapped
    }

    /**
     * @param value The repetition separator.
     */
    @JvmName("bbjbxhagebasainu")
    public suspend fun repetitionSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repetitionSeparator = mapped
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("ygeykpexatylaghe")
    public suspend fun segmentTerminator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminator = mapped
    }

    /**
     * @param value The EDIFACT frame setting segment terminator suffix.
     */
    @JvmName("rjacjerhhvaixgnu")
    public suspend fun segmentTerminatorSuffix(`value`: SegmentTerminatorSuffix) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminatorSuffix = mapped
    }

    /**
     * @param value The service code list directory version.
     */
    @JvmName("brctlkuanowcqqcw")
    public suspend fun serviceCodeListDirectoryVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCodeListDirectoryVersion = mapped
    }

    internal fun build(): EdifactFramingSettingsArgs = EdifactFramingSettingsArgs(
        characterEncoding = characterEncoding,
        characterSet = characterSet ?: throw PulumiNullFieldException("characterSet"),
        componentSeparator = componentSeparator ?: throw PulumiNullFieldException("componentSeparator"),
        dataElementSeparator = dataElementSeparator ?: throw
            PulumiNullFieldException("dataElementSeparator"),
        decimalPointIndicator = decimalPointIndicator ?: throw
            PulumiNullFieldException("decimalPointIndicator"),
        protocolVersion = protocolVersion ?: throw PulumiNullFieldException("protocolVersion"),
        releaseIndicator = releaseIndicator ?: throw PulumiNullFieldException("releaseIndicator"),
        repetitionSeparator = repetitionSeparator ?: throw PulumiNullFieldException("repetitionSeparator"),
        segmentTerminator = segmentTerminator ?: throw PulumiNullFieldException("segmentTerminator"),
        segmentTerminatorSuffix = segmentTerminatorSuffix ?: throw
            PulumiNullFieldException("segmentTerminatorSuffix"),
        serviceCodeListDirectoryVersion = serviceCodeListDirectoryVersion,
    )
}
