@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactProcessingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact agreement protocol settings.
 * @property createEmptyXmlTagsForTrailingSeparators The value indicating whether to create empty xml tags for trailing separators.
 * @property maskSecurityInfo The value indicating whether to mask security information.
 * @property preserveInterchange The value indicating whether to preserve interchange.
 * @property suspendInterchangeOnError The value indicating whether to suspend interchange on error.
 * @property useDotAsDecimalSeparator The value indicating whether to use dot as decimal separator.
 */
public data class EdifactProcessingSettingsArgs(
    public val createEmptyXmlTagsForTrailingSeparators: Output<Boolean>,
    public val maskSecurityInfo: Output<Boolean>,
    public val preserveInterchange: Output<Boolean>,
    public val suspendInterchangeOnError: Output<Boolean>,
    public val useDotAsDecimalSeparator: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactProcessingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactProcessingSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactProcessingSettingsArgs.builder()
            .createEmptyXmlTagsForTrailingSeparators(
                createEmptyXmlTagsForTrailingSeparators.applyValue({ args0 ->
                    args0
                }),
            )
            .maskSecurityInfo(maskSecurityInfo.applyValue({ args0 -> args0 }))
            .preserveInterchange(preserveInterchange.applyValue({ args0 -> args0 }))
            .suspendInterchangeOnError(suspendInterchangeOnError.applyValue({ args0 -> args0 }))
            .useDotAsDecimalSeparator(useDotAsDecimalSeparator.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactProcessingSettingsArgs].
 */
@PulumiTagMarker
public class EdifactProcessingSettingsArgsBuilder internal constructor() {
    private var createEmptyXmlTagsForTrailingSeparators: Output<Boolean>? = null

    private var maskSecurityInfo: Output<Boolean>? = null

    private var preserveInterchange: Output<Boolean>? = null

    private var suspendInterchangeOnError: Output<Boolean>? = null

    private var useDotAsDecimalSeparator: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to create empty xml tags for trailing separators.
     */
    @JvmName("gqtediulvswaioki")
    public suspend fun createEmptyXmlTagsForTrailingSeparators(`value`: Output<Boolean>) {
        this.createEmptyXmlTagsForTrailingSeparators = value
    }

    /**
     * @param value The value indicating whether to mask security information.
     */
    @JvmName("aqldfoeunjhprscp")
    public suspend fun maskSecurityInfo(`value`: Output<Boolean>) {
        this.maskSecurityInfo = value
    }

    /**
     * @param value The value indicating whether to preserve interchange.
     */
    @JvmName("pxsoivudotrwmmyx")
    public suspend fun preserveInterchange(`value`: Output<Boolean>) {
        this.preserveInterchange = value
    }

    /**
     * @param value The value indicating whether to suspend interchange on error.
     */
    @JvmName("jnrqqfjldsayjbnm")
    public suspend fun suspendInterchangeOnError(`value`: Output<Boolean>) {
        this.suspendInterchangeOnError = value
    }

    /**
     * @param value The value indicating whether to use dot as decimal separator.
     */
    @JvmName("wlatdcoqkafnevlp")
    public suspend fun useDotAsDecimalSeparator(`value`: Output<Boolean>) {
        this.useDotAsDecimalSeparator = value
    }

    /**
     * @param value The value indicating whether to create empty xml tags for trailing separators.
     */
    @JvmName("wvdpiqrhwvwfwesg")
    public suspend fun createEmptyXmlTagsForTrailingSeparators(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createEmptyXmlTagsForTrailingSeparators = mapped
    }

    /**
     * @param value The value indicating whether to mask security information.
     */
    @JvmName("iwkibbeupuadmgaa")
    public suspend fun maskSecurityInfo(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maskSecurityInfo = mapped
    }

    /**
     * @param value The value indicating whether to preserve interchange.
     */
    @JvmName("htdldsrtmtglcfsx")
    public suspend fun preserveInterchange(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preserveInterchange = mapped
    }

    /**
     * @param value The value indicating whether to suspend interchange on error.
     */
    @JvmName("dbfgvgytoahuvubx")
    public suspend fun suspendInterchangeOnError(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suspendInterchangeOnError = mapped
    }

    /**
     * @param value The value indicating whether to use dot as decimal separator.
     */
    @JvmName("hgljeccgccaolsbr")
    public suspend fun useDotAsDecimalSeparator(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useDotAsDecimalSeparator = mapped
    }

    internal fun build(): EdifactProcessingSettingsArgs = EdifactProcessingSettingsArgs(
        createEmptyXmlTagsForTrailingSeparators = createEmptyXmlTagsForTrailingSeparators ?: throw
            PulumiNullFieldException("createEmptyXmlTagsForTrailingSeparators"),
        maskSecurityInfo = maskSecurityInfo ?: throw PulumiNullFieldException("maskSecurityInfo"),
        preserveInterchange = preserveInterchange ?: throw PulumiNullFieldException("preserveInterchange"),
        suspendInterchangeOnError = suspendInterchangeOnError ?: throw
            PulumiNullFieldException("suspendInterchangeOnError"),
        useDotAsDecimalSeparator = useDotAsDecimalSeparator ?: throw
            PulumiNullFieldException("useDotAsDecimalSeparator"),
    )
}
