@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Edifact agreement protocol settings.
 * @property acknowledgementSettings The EDIFACT acknowledgement settings.
 * @property edifactDelimiterOverrides The EDIFACT delimiter override settings.
 * @property envelopeOverrides The EDIFACT envelope override settings.
 * @property envelopeSettings The EDIFACT envelope settings.
 * @property framingSettings The EDIFACT framing settings.
 * @property messageFilter The EDIFACT message filter.
 * @property messageFilterList The EDIFACT message filter list.
 * @property processingSettings The EDIFACT processing Settings.
 * @property schemaReferences The EDIFACT schema references.
 * @property validationOverrides The EDIFACT validation override settings.
 * @property validationSettings The EDIFACT validation settings.
 */
public data class EdifactProtocolSettingsArgs(
    public val acknowledgementSettings: Output<EdifactAcknowledgementSettingsArgs>,
    public val edifactDelimiterOverrides: Output<List<EdifactDelimiterOverrideArgs>>? = null,
    public val envelopeOverrides: Output<List<EdifactEnvelopeOverrideArgs>>? = null,
    public val envelopeSettings: Output<EdifactEnvelopeSettingsArgs>,
    public val framingSettings: Output<EdifactFramingSettingsArgs>,
    public val messageFilter: Output<EdifactMessageFilterArgs>,
    public val messageFilterList: Output<List<EdifactMessageIdentifierArgs>>? = null,
    public val processingSettings: Output<EdifactProcessingSettingsArgs>,
    public val schemaReferences: Output<List<EdifactSchemaReferenceArgs>>,
    public val validationOverrides: Output<List<EdifactValidationOverrideArgs>>? = null,
    public val validationSettings: Output<EdifactValidationSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactProtocolSettingsArgs.builder()
            .acknowledgementSettings(
                acknowledgementSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .edifactDelimiterOverrides(
                edifactDelimiterOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .envelopeOverrides(
                envelopeOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .envelopeSettings(envelopeSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .framingSettings(framingSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilter(messageFilter.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .messageFilterList(
                messageFilterList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .processingSettings(
                processingSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaReferences(
                schemaReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .validationOverrides(
                validationOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .validationSettings(
                validationSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EdifactProtocolSettingsArgs].
 */
@PulumiTagMarker
public class EdifactProtocolSettingsArgsBuilder internal constructor() {
    private var acknowledgementSettings: Output<EdifactAcknowledgementSettingsArgs>? = null

    private var edifactDelimiterOverrides: Output<List<EdifactDelimiterOverrideArgs>>? = null

    private var envelopeOverrides: Output<List<EdifactEnvelopeOverrideArgs>>? = null

    private var envelopeSettings: Output<EdifactEnvelopeSettingsArgs>? = null

    private var framingSettings: Output<EdifactFramingSettingsArgs>? = null

    private var messageFilter: Output<EdifactMessageFilterArgs>? = null

    private var messageFilterList: Output<List<EdifactMessageIdentifierArgs>>? = null

    private var processingSettings: Output<EdifactProcessingSettingsArgs>? = null

    private var schemaReferences: Output<List<EdifactSchemaReferenceArgs>>? = null

    private var validationOverrides: Output<List<EdifactValidationOverrideArgs>>? = null

    private var validationSettings: Output<EdifactValidationSettingsArgs>? = null

    /**
     * @param value The EDIFACT acknowledgement settings.
     */
    @JvmName("otditujhuxcvxtvy")
    public suspend fun acknowledgementSettings(`value`: Output<EdifactAcknowledgementSettingsArgs>) {
        this.acknowledgementSettings = value
    }

    /**
     * @param value The EDIFACT delimiter override settings.
     */
    @JvmName("ajmtxsjgbasmkrpy")
    public suspend
    fun edifactDelimiterOverrides(`value`: Output<List<EdifactDelimiterOverrideArgs>>) {
        this.edifactDelimiterOverrides = value
    }

    @JvmName("tplawewxmnqaiklg")
    public suspend fun edifactDelimiterOverrides(
        vararg
        values: Output<EdifactDelimiterOverrideArgs>,
    ) {
        this.edifactDelimiterOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT delimiter override settings.
     */
    @JvmName("mvikasjnoxonjjlo")
    public suspend fun edifactDelimiterOverrides(values: List<Output<EdifactDelimiterOverrideArgs>>) {
        this.edifactDelimiterOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT envelope override settings.
     */
    @JvmName("dmjjeirwhsniiybv")
    public suspend fun envelopeOverrides(`value`: Output<List<EdifactEnvelopeOverrideArgs>>) {
        this.envelopeOverrides = value
    }

    @JvmName("yiyissawdfipnnec")
    public suspend fun envelopeOverrides(vararg values: Output<EdifactEnvelopeOverrideArgs>) {
        this.envelopeOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT envelope override settings.
     */
    @JvmName("xgjwfdvmsdpwgegi")
    public suspend fun envelopeOverrides(values: List<Output<EdifactEnvelopeOverrideArgs>>) {
        this.envelopeOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT envelope settings.
     */
    @JvmName("ukdwpichgcxbgvlm")
    public suspend fun envelopeSettings(`value`: Output<EdifactEnvelopeSettingsArgs>) {
        this.envelopeSettings = value
    }

    /**
     * @param value The EDIFACT framing settings.
     */
    @JvmName("xeslpewefguawfel")
    public suspend fun framingSettings(`value`: Output<EdifactFramingSettingsArgs>) {
        this.framingSettings = value
    }

    /**
     * @param value The EDIFACT message filter.
     */
    @JvmName("xnesyjqkrhhwohdp")
    public suspend fun messageFilter(`value`: Output<EdifactMessageFilterArgs>) {
        this.messageFilter = value
    }

    /**
     * @param value The EDIFACT message filter list.
     */
    @JvmName("qpehvtsgjttfmyxf")
    public suspend fun messageFilterList(`value`: Output<List<EdifactMessageIdentifierArgs>>) {
        this.messageFilterList = value
    }

    @JvmName("drqypjogrtxiihqn")
    public suspend fun messageFilterList(vararg values: Output<EdifactMessageIdentifierArgs>) {
        this.messageFilterList = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT message filter list.
     */
    @JvmName("acipapsbrhcdhaox")
    public suspend fun messageFilterList(values: List<Output<EdifactMessageIdentifierArgs>>) {
        this.messageFilterList = Output.all(values)
    }

    /**
     * @param value The EDIFACT processing Settings.
     */
    @JvmName("kmajktynycmrccej")
    public suspend fun processingSettings(`value`: Output<EdifactProcessingSettingsArgs>) {
        this.processingSettings = value
    }

    /**
     * @param value The EDIFACT schema references.
     */
    @JvmName("ycigtmtkyhauouoc")
    public suspend fun schemaReferences(`value`: Output<List<EdifactSchemaReferenceArgs>>) {
        this.schemaReferences = value
    }

    @JvmName("wgcdwxmgnmbyeowe")
    public suspend fun schemaReferences(vararg values: Output<EdifactSchemaReferenceArgs>) {
        this.schemaReferences = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT schema references.
     */
    @JvmName("xtkdfbhtbtbiyikq")
    public suspend fun schemaReferences(values: List<Output<EdifactSchemaReferenceArgs>>) {
        this.schemaReferences = Output.all(values)
    }

    /**
     * @param value The EDIFACT validation override settings.
     */
    @JvmName("depymxlxmseitjfi")
    public suspend fun validationOverrides(`value`: Output<List<EdifactValidationOverrideArgs>>) {
        this.validationOverrides = value
    }

    @JvmName("fbegeyabxrukmlve")
    public suspend fun validationOverrides(vararg values: Output<EdifactValidationOverrideArgs>) {
        this.validationOverrides = Output.all(values.asList())
    }

    /**
     * @param values The EDIFACT validation override settings.
     */
    @JvmName("hptkcfahjlnhcdhs")
    public suspend fun validationOverrides(values: List<Output<EdifactValidationOverrideArgs>>) {
        this.validationOverrides = Output.all(values)
    }

    /**
     * @param value The EDIFACT validation settings.
     */
    @JvmName("llrvjhyeilgkkhra")
    public suspend fun validationSettings(`value`: Output<EdifactValidationSettingsArgs>) {
        this.validationSettings = value
    }

    /**
     * @param value The EDIFACT acknowledgement settings.
     */
    @JvmName("kllabgpyobogjyvu")
    public suspend fun acknowledgementSettings(`value`: EdifactAcknowledgementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acknowledgementSettings = mapped
    }

    /**
     * @param argument The EDIFACT acknowledgement settings.
     */
    @JvmName("mvjpmfqoqkvsrkde")
    public suspend
    fun acknowledgementSettings(argument: suspend EdifactAcknowledgementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactAcknowledgementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.acknowledgementSettings = mapped
    }

    /**
     * @param value The EDIFACT delimiter override settings.
     */
    @JvmName("kwnxkeysswgxepso")
    public suspend fun edifactDelimiterOverrides(`value`: List<EdifactDelimiterOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("kfafodrnyfqfrmrl")
    public suspend
    fun edifactDelimiterOverrides(argument: List<suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("dbxepgfgpaoaojau")
    public suspend fun edifactDelimiterOverrides(
        vararg
        argument: suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param argument The EDIFACT delimiter override settings.
     */
    @JvmName("mhdlgyfsgotsgmvt")
    public suspend
    fun edifactDelimiterOverrides(argument: suspend EdifactDelimiterOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactDelimiterOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param values The EDIFACT delimiter override settings.
     */
    @JvmName("jdjjxqtsdyarldya")
    public suspend fun edifactDelimiterOverrides(vararg values: EdifactDelimiterOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edifactDelimiterOverrides = mapped
    }

    /**
     * @param value The EDIFACT envelope override settings.
     */
    @JvmName("xoxqfqbealbmthgi")
    public suspend fun envelopeOverrides(`value`: List<EdifactEnvelopeOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("kfykpuggkrehetjo")
    public suspend
    fun envelopeOverrides(argument: List<suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("wydubmpjrugmmvmo")
    public suspend fun envelopeOverrides(
        vararg
        argument: suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param argument The EDIFACT envelope override settings.
     */
    @JvmName("pjysyjviweltyccb")
    public suspend
    fun envelopeOverrides(argument: suspend EdifactEnvelopeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactEnvelopeOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.envelopeOverrides = mapped
    }

    /**
     * @param values The EDIFACT envelope override settings.
     */
    @JvmName("kcponefumubhkmuc")
    public suspend fun envelopeOverrides(vararg values: EdifactEnvelopeOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeOverrides = mapped
    }

    /**
     * @param value The EDIFACT envelope settings.
     */
    @JvmName("hgaypijwtdbtully")
    public suspend fun envelopeSettings(`value`: EdifactEnvelopeSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.envelopeSettings = mapped
    }

    /**
     * @param argument The EDIFACT envelope settings.
     */
    @JvmName("jgbvkihbultxnmsl")
    public suspend
    fun envelopeSettings(argument: suspend EdifactEnvelopeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactEnvelopeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.envelopeSettings = mapped
    }

    /**
     * @param value The EDIFACT framing settings.
     */
    @JvmName("muqlrwaqwookqstf")
    public suspend fun framingSettings(`value`: EdifactFramingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.framingSettings = mapped
    }

    /**
     * @param argument The EDIFACT framing settings.
     */
    @JvmName("pgdceayxwomxlvum")
    public suspend
    fun framingSettings(argument: suspend EdifactFramingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactFramingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.framingSettings = mapped
    }

    /**
     * @param value The EDIFACT message filter.
     */
    @JvmName("psboclhegxwmqaql")
    public suspend fun messageFilter(`value`: EdifactMessageFilterArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilter = mapped
    }

    /**
     * @param argument The EDIFACT message filter.
     */
    @JvmName("poqvfjkpyfskljtm")
    public suspend fun messageFilter(argument: suspend EdifactMessageFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactMessageFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.messageFilter = mapped
    }

    /**
     * @param value The EDIFACT message filter list.
     */
    @JvmName("sikucvgfxwbkglet")
    public suspend fun messageFilterList(`value`: List<EdifactMessageIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("jmchpcpyylcqcivy")
    public suspend
    fun messageFilterList(argument: List<suspend EdifactMessageIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("fvelxnyiuxqydubj")
    public suspend fun messageFilterList(
        vararg
        argument: suspend EdifactMessageIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param argument The EDIFACT message filter list.
     */
    @JvmName("hnsbsrptbsqfpond")
    public suspend
    fun messageFilterList(argument: suspend EdifactMessageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactMessageIdentifierArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messageFilterList = mapped
    }

    /**
     * @param values The EDIFACT message filter list.
     */
    @JvmName("ldvevhiniqubemnu")
    public suspend fun messageFilterList(vararg values: EdifactMessageIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterList = mapped
    }

    /**
     * @param value The EDIFACT processing Settings.
     */
    @JvmName("axdotflhhgfdgswt")
    public suspend fun processingSettings(`value`: EdifactProcessingSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processingSettings = mapped
    }

    /**
     * @param argument The EDIFACT processing Settings.
     */
    @JvmName("eadlmvvuxpwvqayf")
    public suspend
    fun processingSettings(argument: suspend EdifactProcessingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactProcessingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.processingSettings = mapped
    }

    /**
     * @param value The EDIFACT schema references.
     */
    @JvmName("catlbemhgchhrqcd")
    public suspend fun schemaReferences(`value`: List<EdifactSchemaReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("wgmvsiuqqoooxura")
    public suspend
    fun schemaReferences(argument: List<suspend EdifactSchemaReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactSchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("fbdnjxeiumoyouhd")
    public suspend fun schemaReferences(
        vararg
        argument: suspend EdifactSchemaReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactSchemaReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param argument The EDIFACT schema references.
     */
    @JvmName("xyvdxctpgfypkdga")
    public suspend
    fun schemaReferences(argument: suspend EdifactSchemaReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EdifactSchemaReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schemaReferences = mapped
    }

    /**
     * @param values The EDIFACT schema references.
     */
    @JvmName("aibqnpjvanlnipwo")
    public suspend fun schemaReferences(vararg values: EdifactSchemaReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaReferences = mapped
    }

    /**
     * @param value The EDIFACT validation override settings.
     */
    @JvmName("evkeqsbwwsfkmdav")
    public suspend fun validationOverrides(`value`: List<EdifactValidationOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("xoavtlpmythqdpoe")
    public suspend
    fun validationOverrides(argument: List<suspend EdifactValidationOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EdifactValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("wvefywegnpwfgily")
    public suspend fun validationOverrides(
        vararg
        argument: suspend EdifactValidationOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EdifactValidationOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param argument The EDIFACT validation override settings.
     */
    @JvmName("mqjjmovmexexapcf")
    public suspend
    fun validationOverrides(argument: suspend EdifactValidationOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EdifactValidationOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.validationOverrides = mapped
    }

    /**
     * @param values The EDIFACT validation override settings.
     */
    @JvmName("fekwqbkufkgkfvmm")
    public suspend fun validationOverrides(vararg values: EdifactValidationOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationOverrides = mapped
    }

    /**
     * @param value The EDIFACT validation settings.
     */
    @JvmName("qecqrxxowvtxneif")
    public suspend fun validationSettings(`value`: EdifactValidationSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationSettings = mapped
    }

    /**
     * @param argument The EDIFACT validation settings.
     */
    @JvmName("ykgkjsqymeywgstg")
    public suspend
    fun validationSettings(argument: suspend EdifactValidationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = EdifactValidationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validationSettings = mapped
    }

    internal fun build(): EdifactProtocolSettingsArgs = EdifactProtocolSettingsArgs(
        acknowledgementSettings = acknowledgementSettings ?: throw
            PulumiNullFieldException("acknowledgementSettings"),
        edifactDelimiterOverrides = edifactDelimiterOverrides,
        envelopeOverrides = envelopeOverrides,
        envelopeSettings = envelopeSettings ?: throw PulumiNullFieldException("envelopeSettings"),
        framingSettings = framingSettings ?: throw PulumiNullFieldException("framingSettings"),
        messageFilter = messageFilter ?: throw PulumiNullFieldException("messageFilter"),
        messageFilterList = messageFilterList,
        processingSettings = processingSettings ?: throw PulumiNullFieldException("processingSettings"),
        schemaReferences = schemaReferences ?: throw PulumiNullFieldException("schemaReferences"),
        validationOverrides = validationOverrides,
        validationSettings = validationSettings ?: throw PulumiNullFieldException("validationSettings"),
    )
}
