@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.FlowEndpointsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The endpoints configuration.
 * @property connector The connector endpoints.
 * @property workflow The workflow endpoints.
 */
public data class FlowEndpointsConfigurationArgs(
    public val connector: Output<FlowEndpointsArgs>? = null,
    public val workflow: Output<FlowEndpointsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.FlowEndpointsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.FlowEndpointsConfigurationArgs =
        com.pulumi.azurenative.logic.inputs.FlowEndpointsConfigurationArgs.builder()
            .connector(connector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workflow(workflow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowEndpointsConfigurationArgs].
 */
@PulumiTagMarker
public class FlowEndpointsConfigurationArgsBuilder internal constructor() {
    private var connector: Output<FlowEndpointsArgs>? = null

    private var workflow: Output<FlowEndpointsArgs>? = null

    /**
     * @param value The connector endpoints.
     */
    @JvmName("hwjleduuwiksmoif")
    public suspend fun connector(`value`: Output<FlowEndpointsArgs>) {
        this.connector = value
    }

    /**
     * @param value The workflow endpoints.
     */
    @JvmName("jvqbogfyrjexvkil")
    public suspend fun workflow(`value`: Output<FlowEndpointsArgs>) {
        this.workflow = value
    }

    /**
     * @param value The connector endpoints.
     */
    @JvmName("ibpofvsainiongjy")
    public suspend fun connector(`value`: FlowEndpointsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connector = mapped
    }

    /**
     * @param argument The connector endpoints.
     */
    @JvmName("anpgkkmxyhoffbmm")
    public suspend fun connector(argument: suspend FlowEndpointsArgsBuilder.() -> Unit) {
        val toBeMapped = FlowEndpointsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connector = mapped
    }

    /**
     * @param value The workflow endpoints.
     */
    @JvmName("rvmgxstwqjfdhrvf")
    public suspend fun workflow(`value`: FlowEndpointsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflow = mapped
    }

    /**
     * @param argument The workflow endpoints.
     */
    @JvmName("jlxydcvusyynixxy")
    public suspend fun workflow(argument: suspend FlowEndpointsArgsBuilder.() -> Unit) {
        val toBeMapped = FlowEndpointsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workflow = mapped
    }

    internal fun build(): FlowEndpointsConfigurationArgs = FlowEndpointsConfigurationArgs(
        connector = connector,
        workflow = workflow,
    )
}
