@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountMapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property mapName The integration account map name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountMapPlainArgs(
    public val integrationAccountName: String,
    public val mapName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountMapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountMapPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountMapPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .mapName(mapName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountMapPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountMapPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var mapName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("vxawlbjdxvjdugjv")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The integration account map name.
     */
    @JvmName("vjemgommqvmvtkrq")
    public suspend fun mapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mapName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("yoppeshswlqabien")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountMapPlainArgs = GetIntegrationAccountMapPlainArgs(
        integrationAccountName = integrationAccountName ?: throw
            PulumiNullFieldException("integrationAccountName"),
        mapName = mapName ?: throw PulumiNullFieldException("mapName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
