@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationServiceEnvironmentName The integration service environment name.
 * @property resourceGroup The resource group.
 */
public data class GetIntegrationServiceEnvironmentPlainArgs(
    public val integrationServiceEnvironmentName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationServiceEnvironmentPlainArgs.builder()
            .integrationServiceEnvironmentName(integrationServiceEnvironmentName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationServiceEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationServiceEnvironmentPlainArgsBuilder internal constructor() {
    private var integrationServiceEnvironmentName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value The integration service environment name.
     */
    @JvmName("fwdkilkavoqiyutd")
    public suspend fun integrationServiceEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationServiceEnvironmentName = mapped
    }

    /**
     * @param value The resource group.
     */
    @JvmName("sgmnsffjpifysupf")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetIntegrationServiceEnvironmentPlainArgs =
        GetIntegrationServiceEnvironmentPlainArgs(
            integrationServiceEnvironmentName = integrationServiceEnvironmentName ?: throw
                PulumiNullFieldException("integrationServiceEnvironmentName"),
            resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
        )
}
