@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetRosettaNetProcessConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 * @property rosettaNetProcessConfigurationName The integration account RosettaNetProcessConfiguration name.
 */
public data class GetRosettaNetProcessConfigurationPlainArgs(
    public val integrationAccountName: String,
    public val resourceGroupName: String,
    public val rosettaNetProcessConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetRosettaNetProcessConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.GetRosettaNetProcessConfigurationPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetRosettaNetProcessConfigurationPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .rosettaNetProcessConfigurationName(
                rosettaNetProcessConfigurationName.let({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [GetRosettaNetProcessConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetRosettaNetProcessConfigurationPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var rosettaNetProcessConfigurationName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("ecljdpimpeipaxfd")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sdbdxcfasaocftvv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account RosettaNetProcessConfiguration name.
     */
    @JvmName("plpyujglmmpjabps")
    public suspend fun rosettaNetProcessConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rosettaNetProcessConfigurationName = mapped
    }

    internal fun build(): GetRosettaNetProcessConfigurationPlainArgs =
        GetRosettaNetProcessConfigurationPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            rosettaNetProcessConfigurationName = rosettaNetProcessConfigurationName ?: throw
                PulumiNullFieldException("rosettaNetProcessConfigurationName"),
        )
}
