@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IpAddressRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ip address range.
 * @property addressRange The IP address range.
 */
public data class IpAddressRangeArgs(
    public val addressRange: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IpAddressRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IpAddressRangeArgs =
        com.pulumi.azurenative.logic.inputs.IpAddressRangeArgs.builder()
            .addressRange(addressRange?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpAddressRangeArgs].
 */
@PulumiTagMarker
public class IpAddressRangeArgsBuilder internal constructor() {
    private var addressRange: Output<String>? = null

    /**
     * @param value The IP address range.
     */
    @JvmName("pckrnawcpbiotqbc")
    public suspend fun addressRange(`value`: Output<String>) {
        this.addressRange = value
    }

    /**
     * @param value The IP address range.
     */
    @JvmName("rvekgsoddeexcvey")
    public suspend fun addressRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressRange = mapped
    }

    internal fun build(): IpAddressRangeArgs = IpAddressRangeArgs(
        addressRange = addressRange,
    )
}
