@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.KeyVaultReference.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The key vault reference.
 * @property id The resource id.
 * @property name The key vault name.
 */
public data class KeyVaultReference(
    public val id: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.KeyVaultReference> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.KeyVaultReference =
        com.pulumi.azurenative.logic.inputs.KeyVaultReference.builder()
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultReference].
 */
@PulumiTagMarker
public class KeyVaultReferenceBuilder internal constructor() {
    private var id: String? = null

    private var name: String? = null

    /**
     * @param value The resource id.
     */
    @JvmName("fwylmhcxmtufrwno")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The key vault name.
     */
    @JvmName("dewfpvhthaccjasc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): KeyVaultReference = KeyVaultReference(
        id = id,
        name = name,
    )
}
