@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agreementName The integration account agreement name.
 * @property integrationAccountName The integration account name.
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 */
public data class ListIntegrationAccountAgreementContentCallbackUrlPlainArgs(
    public val agreementName: String,
    public val integrationAccountName: String,
    public val keyType: Either<String, KeyType>? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountAgreementContentCallbackUrlPlainArgs.builder()
            .agreementName(agreementName.let({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIntegrationAccountAgreementContentCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListIntegrationAccountAgreementContentCallbackUrlPlainArgsBuilder internal
constructor() {
    private var agreementName: String? = null

    private var integrationAccountName: String? = null

    private var keyType: Either<String, KeyType>? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account agreement name.
     */
    @JvmName("koudyilmjweugigl")
    public suspend fun agreementName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agreementName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("ttdbcblefixydiyb")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("rmqugxvcfuqoabmi")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("vhgvfctlxecafidb")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("uolbrsjqusiidfvs")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("tiseycglbvtoittl")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("bnwldspbetgehyso")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListIntegrationAccountAgreementContentCallbackUrlPlainArgs =
        ListIntegrationAccountAgreementContentCallbackUrlPlainArgs(
            agreementName = agreementName ?: throw PulumiNullFieldException("agreementName"),
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
