@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property keyType The key type.
 * @property mapName The integration account map name.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 */
public data class ListIntegrationAccountMapContentCallbackUrlPlainArgs(
    public val integrationAccountName: String,
    public val keyType: Either<String, KeyType>? = null,
    public val mapName: String,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountMapContentCallbackUrlPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .keyType(
                keyType?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mapName(mapName.let({ args0 -> args0 }))
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIntegrationAccountMapContentCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListIntegrationAccountMapContentCallbackUrlPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var keyType: Either<String, KeyType>? = null

    private var mapName: String? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("ntelflajmpgaytxy")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("bwbnoadjxaccrusl")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("bxspcuvwiydqynmt")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The key type.
     */
    @JvmName("hjvuejwpdiprdogr")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The integration account map name.
     */
    @JvmName("kljxqxeaodkgkewq")
    public suspend fun mapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mapName = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("adrujvigcjjbvwhb")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qkjhulbseojkaknn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListIntegrationAccountMapContentCallbackUrlPlainArgs =
        ListIntegrationAccountMapContentCallbackUrlPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            keyType = keyType,
            mapName = mapName ?: throw PulumiNullFieldException("mapName"),
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
