@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPolicyArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.OpenAuthenticationProviderType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Open authentication access policy defined by user.
 * @property claims The access policy claims.
 * @property type Type of provider for OAuth.
 */
public data class OpenAuthenticationAccessPolicyArgs(
    public val claims: Output<List<OpenAuthenticationPolicyClaimArgs>>? = null,
    public val type: Output<Either<String, OpenAuthenticationProviderType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPolicyArgs =
        com.pulumi.azurenative.logic.inputs.OpenAuthenticationAccessPolicyArgs.builder()
            .claims(claims?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenAuthenticationAccessPolicyArgs].
 */
@PulumiTagMarker
public class OpenAuthenticationAccessPolicyArgsBuilder internal constructor() {
    private var claims: Output<List<OpenAuthenticationPolicyClaimArgs>>? = null

    private var type: Output<Either<String, OpenAuthenticationProviderType>>? = null

    /**
     * @param value The access policy claims.
     */
    @JvmName("acuopsjjwbugjqmy")
    public suspend fun claims(`value`: Output<List<OpenAuthenticationPolicyClaimArgs>>) {
        this.claims = value
    }

    @JvmName("dupvwadhmxwxkojw")
    public suspend fun claims(vararg values: Output<OpenAuthenticationPolicyClaimArgs>) {
        this.claims = Output.all(values.asList())
    }

    /**
     * @param values The access policy claims.
     */
    @JvmName("cdmfesuncgmalapf")
    public suspend fun claims(values: List<Output<OpenAuthenticationPolicyClaimArgs>>) {
        this.claims = Output.all(values)
    }

    /**
     * @param value Type of provider for OAuth.
     */
    @JvmName("qydtnhxadghplwpq")
    public suspend fun type(`value`: Output<Either<String, OpenAuthenticationProviderType>>) {
        this.type = value
    }

    /**
     * @param value The access policy claims.
     */
    @JvmName("lfhyfrcfrqxflbqa")
    public suspend fun claims(`value`: List<OpenAuthenticationPolicyClaimArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claims = mapped
    }

    /**
     * @param argument The access policy claims.
     */
    @JvmName("jjnroyuaqfjlyyss")
    public suspend
    fun claims(argument: List<suspend OpenAuthenticationPolicyClaimArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenAuthenticationPolicyClaimArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param argument The access policy claims.
     */
    @JvmName("uvrgfctdfetxjvml")
    public suspend fun claims(
        vararg
        argument: suspend OpenAuthenticationPolicyClaimArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OpenAuthenticationPolicyClaimArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param argument The access policy claims.
     */
    @JvmName("kanieghrigfasrbg")
    public suspend fun claims(argument: suspend OpenAuthenticationPolicyClaimArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenAuthenticationPolicyClaimArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param values The access policy claims.
     */
    @JvmName("qlnlvxpwmsnypawo")
    public suspend fun claims(vararg values: OpenAuthenticationPolicyClaimArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.claims = mapped
    }

    /**
     * @param value Type of provider for OAuth.
     */
    @JvmName("lgxesprpgtmbktbo")
    public suspend fun type(`value`: Either<String, OpenAuthenticationProviderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of provider for OAuth.
     */
    @JvmName("gfkwlryxfunibqto")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OpenAuthenticationProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of provider for OAuth.
     */
    @JvmName("mvwyonbbenliasco")
    public fun type(`value`: OpenAuthenticationProviderType) {
        val toBeMapped = Either.ofRight<String, OpenAuthenticationProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OpenAuthenticationAccessPolicyArgs = OpenAuthenticationAccessPolicyArgs(
        claims = claims,
        type = type,
    )
}
