@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.OpenAuthenticationPolicyClaimArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Open authentication policy claim.
 * @property name The name of the claim.
 * @property value The value of the claim.
 */
public data class OpenAuthenticationPolicyClaimArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.OpenAuthenticationPolicyClaimArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.OpenAuthenticationPolicyClaimArgs =
        com.pulumi.azurenative.logic.inputs.OpenAuthenticationPolicyClaimArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenAuthenticationPolicyClaimArgs].
 */
@PulumiTagMarker
public class OpenAuthenticationPolicyClaimArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the claim.
     */
    @JvmName("tixsmdvcrxldoosl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the claim.
     */
    @JvmName("ycdsddsyhhpbwlly")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the claim.
     */
    @JvmName("eoswuseuoxgcnwyn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the claim.
     */
    @JvmName("nfpoaeryycpjbdmj")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): OpenAuthenticationPolicyClaimArgs = OpenAuthenticationPolicyClaimArgs(
        name = name,
        `value` = `value`,
    )
}
