@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.RosettaNetPipRoleType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The integration account RosettaNet ProcessConfiguration role settings.
 * @property action The action name.
 * @property businessDocument The RosettaNet ProcessConfiguration business document.
 * @property description The description.
 * @property role The role name.
 * @property roleType The RosettaNet ProcessConfiguration role type.
 * @property service The service name.
 * @property serviceClassification The service classification name.
 */
public data class RosettaNetPipRoleSettingsArgs(
    public val action: Output<String>,
    public val businessDocument: Output<RosettaNetPipBusinessDocumentArgs>,
    public val description: Output<String>? = null,
    public val role: Output<String>,
    public val roleType: Output<RosettaNetPipRoleType>,
    public val service: Output<String>,
    public val serviceClassification: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs =
        com.pulumi.azurenative.logic.inputs.RosettaNetPipRoleSettingsArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .businessDocument(businessDocument.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .role(role.applyValue({ args0 -> args0 }))
            .roleType(roleType.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .service(service.applyValue({ args0 -> args0 }))
            .serviceClassification(serviceClassification.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RosettaNetPipRoleSettingsArgs].
 */
@PulumiTagMarker
public class RosettaNetPipRoleSettingsArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var businessDocument: Output<RosettaNetPipBusinessDocumentArgs>? = null

    private var description: Output<String>? = null

    private var role: Output<String>? = null

    private var roleType: Output<RosettaNetPipRoleType>? = null

    private var service: Output<String>? = null

    private var serviceClassification: Output<String>? = null

    /**
     * @param value The action name.
     */
    @JvmName("debfylnpwbqgxbwu")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The RosettaNet ProcessConfiguration business document.
     */
    @JvmName("wejrtigcibflvucd")
    public suspend fun businessDocument(`value`: Output<RosettaNetPipBusinessDocumentArgs>) {
        this.businessDocument = value
    }

    /**
     * @param value The description.
     */
    @JvmName("cjfovuabgorunkqk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("wrumpovprvgkqcdf")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The RosettaNet ProcessConfiguration role type.
     */
    @JvmName("gvldsqrgapwrmvnj")
    public suspend fun roleType(`value`: Output<RosettaNetPipRoleType>) {
        this.roleType = value
    }

    /**
     * @param value The service name.
     */
    @JvmName("dqunvycaodpgtjux")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The service classification name.
     */
    @JvmName("faarxplmdvlnypds")
    public suspend fun serviceClassification(`value`: Output<String>) {
        this.serviceClassification = value
    }

    /**
     * @param value The action name.
     */
    @JvmName("slbcqvhbirxkwybq")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The RosettaNet ProcessConfiguration business document.
     */
    @JvmName("xfymaplujexgvfmm")
    public suspend fun businessDocument(`value`: RosettaNetPipBusinessDocumentArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessDocument = mapped
    }

    /**
     * @param argument The RosettaNet ProcessConfiguration business document.
     */
    @JvmName("rkeceesoxbysvemc")
    public suspend
    fun businessDocument(argument: suspend RosettaNetPipBusinessDocumentArgsBuilder.() -> Unit) {
        val toBeMapped = RosettaNetPipBusinessDocumentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.businessDocument = mapped
    }

    /**
     * @param value The description.
     */
    @JvmName("blqgrmlyhlntekwj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("cquxauubyeoxwyjy")
    public suspend fun role(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The RosettaNet ProcessConfiguration role type.
     */
    @JvmName("aiihihfttuutbpah")
    public suspend fun roleType(`value`: RosettaNetPipRoleType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value The service name.
     */
    @JvmName("aenvyjukcqnbbomq")
    public suspend fun service(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param value The service classification name.
     */
    @JvmName("wstwhodjtblnkoty")
    public suspend fun serviceClassification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceClassification = mapped
    }

    internal fun build(): RosettaNetPipRoleSettingsArgs = RosettaNetPipRoleSettingsArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        businessDocument = businessDocument ?: throw PulumiNullFieldException("businessDocument"),
        description = description,
        role = role ?: throw PulumiNullFieldException("role"),
        roleType = roleType ?: throw PulumiNullFieldException("roleType"),
        service = service ?: throw PulumiNullFieldException("service"),
        serviceClassification = serviceClassification ?: throw
            PulumiNullFieldException("serviceClassification"),
    )
}
