@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12FramingSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.SegmentTerminatorSuffix
import com.pulumi.azurenative.logic.kotlin.enums.X12CharacterSet
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 agreement framing settings.
 * @property characterSet The X12 character set.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property replaceCharacter The replacement character.
 * @property replaceSeparatorsInPayload The value indicating whether to replace separators in payload.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 */
public data class X12FramingSettingsArgs(
    public val characterSet: Output<Either<String, X12CharacterSet>>,
    public val componentSeparator: Output<Int>,
    public val dataElementSeparator: Output<Int>,
    public val replaceCharacter: Output<Int>,
    public val replaceSeparatorsInPayload: Output<Boolean>,
    public val segmentTerminator: Output<Int>,
    public val segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12FramingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12FramingSettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12FramingSettingsArgs.builder()
            .characterSet(
                characterSet.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .componentSeparator(componentSeparator.applyValue({ args0 -> args0 }))
            .dataElementSeparator(dataElementSeparator.applyValue({ args0 -> args0 }))
            .replaceCharacter(replaceCharacter.applyValue({ args0 -> args0 }))
            .replaceSeparatorsInPayload(replaceSeparatorsInPayload.applyValue({ args0 -> args0 }))
            .segmentTerminator(segmentTerminator.applyValue({ args0 -> args0 }))
            .segmentTerminatorSuffix(
                segmentTerminatorSuffix.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [X12FramingSettingsArgs].
 */
@PulumiTagMarker
public class X12FramingSettingsArgsBuilder internal constructor() {
    private var characterSet: Output<Either<String, X12CharacterSet>>? = null

    private var componentSeparator: Output<Int>? = null

    private var dataElementSeparator: Output<Int>? = null

    private var replaceCharacter: Output<Int>? = null

    private var replaceSeparatorsInPayload: Output<Boolean>? = null

    private var segmentTerminator: Output<Int>? = null

    private var segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>? = null

    /**
     * @param value The X12 character set.
     */
    @JvmName("kullwburyxylkafu")
    public suspend fun characterSet(`value`: Output<Either<String, X12CharacterSet>>) {
        this.characterSet = value
    }

    /**
     * @param value The component separator.
     */
    @JvmName("ytytvkxmdascqpfs")
    public suspend fun componentSeparator(`value`: Output<Int>) {
        this.componentSeparator = value
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("ghsoxxqnqxoekvbm")
    public suspend fun dataElementSeparator(`value`: Output<Int>) {
        this.dataElementSeparator = value
    }

    /**
     * @param value The replacement character.
     */
    @JvmName("cvnjphfofsthdhqf")
    public suspend fun replaceCharacter(`value`: Output<Int>) {
        this.replaceCharacter = value
    }

    /**
     * @param value The value indicating whether to replace separators in payload.
     */
    @JvmName("ymkpnelqfqtpddqn")
    public suspend fun replaceSeparatorsInPayload(`value`: Output<Boolean>) {
        this.replaceSeparatorsInPayload = value
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("mevobjrocruvvoum")
    public suspend fun segmentTerminator(`value`: Output<Int>) {
        this.segmentTerminator = value
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("kcptmggyjcfjpxkf")
    public suspend fun segmentTerminatorSuffix(`value`: Output<SegmentTerminatorSuffix>) {
        this.segmentTerminatorSuffix = value
    }

    /**
     * @param value The X12 character set.
     */
    @JvmName("dokrdqbcololvfxw")
    public suspend fun characterSet(`value`: Either<String, X12CharacterSet>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The X12 character set.
     */
    @JvmName("wudrdnprpcywykbe")
    public fun characterSet(`value`: String) {
        val toBeMapped = Either.ofLeft<String, X12CharacterSet>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The X12 character set.
     */
    @JvmName("vkwuehnqiavaiayq")
    public fun characterSet(`value`: X12CharacterSet) {
        val toBeMapped = Either.ofRight<String, X12CharacterSet>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.characterSet = mapped
    }

    /**
     * @param value The component separator.
     */
    @JvmName("drolilbwjvihmckc")
    public suspend fun componentSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentSeparator = mapped
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("gjeuigqubuvspccn")
    public suspend fun dataElementSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataElementSeparator = mapped
    }

    /**
     * @param value The replacement character.
     */
    @JvmName("enbbdyoxawutvcmi")
    public suspend fun replaceCharacter(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replaceCharacter = mapped
    }

    /**
     * @param value The value indicating whether to replace separators in payload.
     */
    @JvmName("irmaxphqfhxtoftj")
    public suspend fun replaceSeparatorsInPayload(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replaceSeparatorsInPayload = mapped
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("lwcaemvpdadxfucj")
    public suspend fun segmentTerminator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminator = mapped
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("mybnpfhupdwdsgoj")
    public suspend fun segmentTerminatorSuffix(`value`: SegmentTerminatorSuffix) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminatorSuffix = mapped
    }

    internal fun build(): X12FramingSettingsArgs = X12FramingSettingsArgs(
        characterSet = characterSet ?: throw PulumiNullFieldException("characterSet"),
        componentSeparator = componentSeparator ?: throw PulumiNullFieldException("componentSeparator"),
        dataElementSeparator = dataElementSeparator ?: throw
            PulumiNullFieldException("dataElementSeparator"),
        replaceCharacter = replaceCharacter ?: throw PulumiNullFieldException("replaceCharacter"),
        replaceSeparatorsInPayload = replaceSeparatorsInPayload ?: throw
            PulumiNullFieldException("replaceSeparatorsInPayload"),
        segmentTerminator = segmentTerminator ?: throw PulumiNullFieldException("segmentTerminator"),
        segmentTerminatorSuffix = segmentTerminatorSuffix ?: throw
            PulumiNullFieldException("segmentTerminatorSuffix"),
    )
}
