@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12OneWayAgreementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The X12 one-way agreement.
 * @property protocolSettings The X12 protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class X12OneWayAgreementArgs(
    public val protocolSettings: Output<X12ProtocolSettingsArgs>,
    public val receiverBusinessIdentity: Output<BusinessIdentityArgs>,
    public val senderBusinessIdentity: Output<BusinessIdentityArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12OneWayAgreementArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12OneWayAgreementArgs =
        com.pulumi.azurenative.logic.inputs.X12OneWayAgreementArgs.builder()
            .protocolSettings(protocolSettings.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .receiverBusinessIdentity(
                receiverBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .senderBusinessIdentity(
                senderBusinessIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [X12OneWayAgreementArgs].
 */
@PulumiTagMarker
public class X12OneWayAgreementArgsBuilder internal constructor() {
    private var protocolSettings: Output<X12ProtocolSettingsArgs>? = null

    private var receiverBusinessIdentity: Output<BusinessIdentityArgs>? = null

    private var senderBusinessIdentity: Output<BusinessIdentityArgs>? = null

    /**
     * @param value The X12 protocol settings.
     */
    @JvmName("qhkhvrxfwbllgxyv")
    public suspend fun protocolSettings(`value`: Output<X12ProtocolSettingsArgs>) {
        this.protocolSettings = value
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("lqotgxmmqyfsfkts")
    public suspend fun receiverBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.receiverBusinessIdentity = value
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("bsxvtbrfbgnfjeov")
    public suspend fun senderBusinessIdentity(`value`: Output<BusinessIdentityArgs>) {
        this.senderBusinessIdentity = value
    }

    /**
     * @param value The X12 protocol settings.
     */
    @JvmName("qvlsjrikiyusmqyf")
    public suspend fun protocolSettings(`value`: X12ProtocolSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolSettings = mapped
    }

    /**
     * @param argument The X12 protocol settings.
     */
    @JvmName("xshaalleaitbwpwi")
    public suspend fun protocolSettings(argument: suspend X12ProtocolSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = X12ProtocolSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolSettings = mapped
    }

    /**
     * @param value The receiver business identity
     */
    @JvmName("oskregfmapqngqjs")
    public suspend fun receiverBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param argument The receiver business identity
     */
    @JvmName("wqrsthdxeotlcwnu")
    public suspend
    fun receiverBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiverBusinessIdentity = mapped
    }

    /**
     * @param value The sender business identity
     */
    @JvmName("ogmlwjwjejoloukj")
    public suspend fun senderBusinessIdentity(`value`: BusinessIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.senderBusinessIdentity = mapped
    }

    /**
     * @param argument The sender business identity
     */
    @JvmName("ghdfqcqoekuoplok")
    public suspend
    fun senderBusinessIdentity(argument: suspend BusinessIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.senderBusinessIdentity = mapped
    }

    internal fun build(): X12OneWayAgreementArgs = X12OneWayAgreementArgs(
        protocolSettings = protocolSettings ?: throw PulumiNullFieldException("protocolSettings"),
        receiverBusinessIdentity = receiverBusinessIdentity ?: throw
            PulumiNullFieldException("receiverBusinessIdentity"),
        senderBusinessIdentity = senderBusinessIdentity ?: throw
            PulumiNullFieldException("senderBusinessIdentity"),
    )
}
