@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12ValidationOverrideArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.TrailingSeparatorPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 validation override settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property messageId The message id on which the validation settings has to be applied.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateCharacterSet The value indicating whether to validate character Set.
 * @property validateEDITypes The value indicating whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to validate XSD types.
 */
public data class X12ValidationOverrideArgs(
    public val allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val messageId: Output<String>,
    public val trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>,
    public val trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val validateCharacterSet: Output<Boolean>,
    public val validateEDITypes: Output<Boolean>,
    public val validateXSDTypes: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12ValidationOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12ValidationOverrideArgs =
        com.pulumi.azurenative.logic.inputs.X12ValidationOverrideArgs.builder()
            .allowLeadingAndTrailingSpacesAndZeroes(
                allowLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .messageId(messageId.applyValue({ args0 -> args0 }))
            .trailingSeparatorPolicy(
                trailingSeparatorPolicy.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .trimLeadingAndTrailingSpacesAndZeroes(
                trimLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .validateCharacterSet(validateCharacterSet.applyValue({ args0 -> args0 }))
            .validateEDITypes(validateEDITypes.applyValue({ args0 -> args0 }))
            .validateXSDTypes(validateXSDTypes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12ValidationOverrideArgs].
 */
@PulumiTagMarker
public class X12ValidationOverrideArgsBuilder internal constructor() {
    private var allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var messageId: Output<String>? = null

    private var trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>? = null

    private var trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var validateCharacterSet: Output<Boolean>? = null

    private var validateEDITypes: Output<Boolean>? = null

    private var validateXSDTypes: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("vnxiqiicycxwnsgs")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.allowLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The message id on which the validation settings has to be applied.
     */
    @JvmName("bfnrmiwjvsdppsvp")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("vseewfbuixnmvkmf")
    public suspend
    fun trailingSeparatorPolicy(`value`: Output<Either<String, TrailingSeparatorPolicy>>) {
        this.trailingSeparatorPolicy = value
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("ujwxlbfkmhbeywph")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.trimLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The value indicating whether to validate character Set.
     */
    @JvmName("legnfbjfocxgvyxs")
    public suspend fun validateCharacterSet(`value`: Output<Boolean>) {
        this.validateCharacterSet = value
    }

    /**
     * @param value The value indicating whether to validate EDI types.
     */
    @JvmName("bubwltxfduiyohvu")
    public suspend fun validateEDITypes(`value`: Output<Boolean>) {
        this.validateEDITypes = value
    }

    /**
     * @param value The value indicating whether to validate XSD types.
     */
    @JvmName("ihxsxwcicgfeadhg")
    public suspend fun validateXSDTypes(`value`: Output<Boolean>) {
        this.validateXSDTypes = value
    }

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("uqbgqwjwhbnscuxy")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The message id on which the validation settings has to be applied.
     */
    @JvmName("cuntukqytrxddtyb")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("ptjnbtmguiesquot")
    public suspend fun trailingSeparatorPolicy(`value`: Either<String, TrailingSeparatorPolicy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("vfkrtrijefeaswyy")
    public fun trailingSeparatorPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("rdulnyikfgejawqs")
    public fun trailingSeparatorPolicy(`value`: TrailingSeparatorPolicy) {
        val toBeMapped = Either.ofRight<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("rvkrdpffdnowwiqd")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trimLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The value indicating whether to validate character Set.
     */
    @JvmName("jautlniolxsrbqsi")
    public suspend fun validateCharacterSet(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateCharacterSet = mapped
    }

    /**
     * @param value The value indicating whether to validate EDI types.
     */
    @JvmName("jsvwbmfxxrnolofl")
    public suspend fun validateEDITypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateEDITypes = mapped
    }

    /**
     * @param value The value indicating whether to validate XSD types.
     */
    @JvmName("ccruxrcpgkbctmlb")
    public suspend fun validateXSDTypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateXSDTypes = mapped
    }

    internal fun build(): X12ValidationOverrideArgs = X12ValidationOverrideArgs(
        allowLeadingAndTrailingSpacesAndZeroes = allowLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("allowLeadingAndTrailingSpacesAndZeroes"),
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
        trailingSeparatorPolicy = trailingSeparatorPolicy ?: throw
            PulumiNullFieldException("trailingSeparatorPolicy"),
        trimLeadingAndTrailingSpacesAndZeroes = trimLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("trimLeadingAndTrailingSpacesAndZeroes"),
        validateCharacterSet = validateCharacterSet ?: throw
            PulumiNullFieldException("validateCharacterSet"),
        validateEDITypes = validateEDITypes ?: throw PulumiNullFieldException("validateEDITypes"),
        validateXSDTypes = validateXSDTypes ?: throw PulumiNullFieldException("validateXSDTypes"),
    )
}
