@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The AS2 agreement protocol settings.
 * @property acknowledgementConnectionSettings The acknowledgement connection settings.
 * @property envelopeSettings The envelope settings.
 * @property errorSettings The error settings.
 * @property mdnSettings The MDN settings.
 * @property messageConnectionSettings The message connection settings.
 * @property securitySettings The security settings.
 * @property validationSettings The validation settings.
 */
public data class AS2ProtocolSettingsResponse(
    public val acknowledgementConnectionSettings: AS2AcknowledgementConnectionSettingsResponse,
    public val envelopeSettings: AS2EnvelopeSettingsResponse,
    public val errorSettings: AS2ErrorSettingsResponse,
    public val mdnSettings: AS2MdnSettingsResponse,
    public val messageConnectionSettings: AS2MessageConnectionSettingsResponse,
    public val securitySettings: AS2SecuritySettingsResponse,
    public val validationSettings: AS2ValidationSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2ProtocolSettingsResponse):
            AS2ProtocolSettingsResponse = AS2ProtocolSettingsResponse(
            acknowledgementConnectionSettings = javaType.acknowledgementConnectionSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2AcknowledgementConnectionSettingsResponse.Companion.toKotlin(args0)
            }),
            envelopeSettings = javaType.envelopeSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2EnvelopeSettingsResponse.Companion.toKotlin(args0)
            }),
            errorSettings = javaType.errorSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2ErrorSettingsResponse.Companion.toKotlin(args0)
            }),
            mdnSettings = javaType.mdnSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2MdnSettingsResponse.Companion.toKotlin(args0)
            }),
            messageConnectionSettings = javaType.messageConnectionSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2MessageConnectionSettingsResponse.Companion.toKotlin(args0)
            }),
            securitySettings = javaType.securitySettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2SecuritySettingsResponse.Companion.toKotlin(args0)
            }),
            validationSettings = javaType.validationSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2ValidationSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
