@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The API deployment parameters metadata.
 * @property packageContentLink The package content link parameter.
 * @property redisCacheConnectionString The package content link parameter.
 */
public data class ApiDeploymentParameterMetadataSetResponse(
    public val packageContentLink: ApiDeploymentParameterMetadataResponse? = null,
    public val redisCacheConnectionString: ApiDeploymentParameterMetadataResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiDeploymentParameterMetadataSetResponse):
            ApiDeploymentParameterMetadataSetResponse = ApiDeploymentParameterMetadataSetResponse(
            packageContentLink = javaType.packageContentLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiDeploymentParameterMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redisCacheConnectionString = javaType.redisCacheConnectionString().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiDeploymentParameterMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
