@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Edifact schema reference.
 * @property associationAssignedCode The association assigned code.
 * @property messageId The message id.
 * @property messageRelease The message release version.
 * @property messageVersion The message version.
 * @property schemaName The schema name.
 * @property senderApplicationId The sender application id.
 * @property senderApplicationQualifier The sender application qualifier.
 */
public data class EdifactSchemaReferenceResponse(
    public val associationAssignedCode: String? = null,
    public val messageId: String,
    public val messageRelease: String,
    public val messageVersion: String,
    public val schemaName: String,
    public val senderApplicationId: String? = null,
    public val senderApplicationQualifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactSchemaReferenceResponse):
            EdifactSchemaReferenceResponse = EdifactSchemaReferenceResponse(
            associationAssignedCode = javaType.associationAssignedCode().map({ args0 -> args0 }).orElse(null),
            messageId = javaType.messageId(),
            messageRelease = javaType.messageRelease(),
            messageVersion = javaType.messageVersion(),
            schemaName = javaType.schemaName(),
            senderApplicationId = javaType.senderApplicationId().map({ args0 -> args0 }).orElse(null),
            senderApplicationQualifier = javaType.senderApplicationQualifier().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
