@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account agreement.
 * @property agreementType The agreement type.
 * @property changedTime The changed time.
 * @property content The agreement content.
 * @property createdTime The created time.
 * @property guestIdentity The business identity of the guest partner.
 * @property guestPartner The integration account partner that is set as guest partner for this agreement.
 * @property hostIdentity The business identity of the host partner.
 * @property hostPartner The integration account partner that is set as host partner for this agreement.
 * @property id The resource id.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountAgreementResult(
    public val agreementType: String,
    public val changedTime: String,
    public val content: AgreementContentResponse,
    public val createdTime: String,
    public val guestIdentity: BusinessIdentityResponse,
    public val guestPartner: String,
    public val hostIdentity: BusinessIdentityResponse,
    public val hostPartner: String,
    public val id: String,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountAgreementResult):
            GetIntegrationAccountAgreementResult = GetIntegrationAccountAgreementResult(
            agreementType = javaType.agreementType(),
            changedTime = javaType.changedTime(),
            content = javaType.content().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AgreementContentResponse.Companion.toKotlin(args0)
            }),
            createdTime = javaType.createdTime(),
            guestIdentity = javaType.guestIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
            guestPartner = javaType.guestPartner(),
            hostIdentity = javaType.hostIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
            hostPartner = javaType.hostPartner(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
